/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.markup;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderException;
import com.atlassian.bitbucket.markup.UrlMode;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.markup.MarkupFactory;
import com.atlassian.markup.MarkupOptions;
import com.atlassian.markup.MarkupParser;
import com.atlassian.markup.renderer.MarkupRenderer;
import com.atlassian.markup.renderer.RenderContext;
import com.atlassian.markup.renderer.impl.MarkupRendererImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=MarkupService.class)
@Service(value="renderService")
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class DefaultMarkupService
implements MarkupService {
    private final LazyReference<MarkupParser> parser;
    private final PluginAccessor pluginAccessor;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final boolean hardwrapByDefault;
    private final boolean htmlEscapeByDefault;

    @Autowired
    public DefaultMarkupService(NavBuilder navBuilder, PluginAccessor pluginAccessor, final MarkupFactory markupFactory, I18nService i18nService, final @Value(value="${markup.render.type}") String renderType, @Value(value="${markup.render.hardwrap}") boolean hardwrapByDefault, @Value(value="${markup.render.html.escape}") boolean htmlEscapeByDefault) {
        this.navBuilder = navBuilder;
        this.pluginAccessor = pluginAccessor;
        this.i18nService = i18nService;
        this.hardwrapByDefault = htmlEscapeByDefault;
        this.htmlEscapeByDefault = htmlEscapeByDefault;
        this.parser = new LazyReference<MarkupParser>(){

            protected MarkupParser create() throws Exception {
                return markupFactory.getParser("file." + renderType);
            }
        };
    }

    @Nonnull
    public String render(@Nonnull String content, @Nonnull com.atlassian.bitbucket.markup.RenderContext renderContext) {
        try {
            return IOUtils.toString((Reader)this.createRenderer(renderContext).render((Reader)new StringReader(content), this.createContext(renderContext)));
        }
        catch (IOException e) {
            throw new RenderException(this.i18nService.createKeyedMessage("bitbucket.service.markup.render", new Object[0]), (Throwable)e);
        }
    }

    public void stream(@Nonnull Reader reader, @Nonnull Appendable writer, @Nonnull com.atlassian.bitbucket.markup.RenderContext renderContext) {
        try {
            CharStreams.copy((Readable)this.createRenderer(renderContext).render(reader, this.createContext(renderContext)), (Appendable)writer);
        }
        catch (IOException e) {
            throw new RenderException(this.i18nService.createKeyedMessage("bitbucket.service.markup.stream", new Object[0]), (Throwable)e);
        }
    }

    private MarkupRenderer createRenderer(final com.atlassian.bitbucket.markup.RenderContext context) {
        return new MarkupRendererImpl(this.pluginAccessor, (Function)new Function<CharSequence, CharSequence>(){

            public CharSequence apply(CharSequence input) {
                return ((MarkupParser)DefaultMarkupService.this.parser.get()).markup(input.toString(), this.createMarkupOptions(context));
            }

            private MarkupOptions createMarkupOptions(com.atlassian.bitbucket.markup.RenderContext context2) {
                return MarkupOptions.builder().hardwrap(((Boolean)MoreObjects.firstNonNull((Object)context2.getHardwrap(), (Object)DefaultMarkupService.this.hardwrapByDefault)).booleanValue()).htmlEscaped(((Boolean)MoreObjects.firstNonNull((Object)context2.getHtmlEscaped(), (Object)DefaultMarkupService.this.htmlEscapeByDefault)).booleanValue()).build();
            }
        });
    }

    private RenderContext createContext(com.atlassian.bitbucket.markup.RenderContext renderContext) {
        RenderContext.Builder builder = new RenderContext.Builder().baseUrl(this.getBaseUrl(renderContext.getUrlMode()));
        if (renderContext.getData() != null) {
            builder.setData(renderContext.getData());
        }
        return builder.build();
    }

    private String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case CONFIGURED: {
                return this.navBuilder.buildConfigured();
            }
            case ABSOLUTE: {
                return this.navBuilder.buildAbsolute();
            }
            case RELATIVE: {
                return this.navBuilder.buildRelative();
            }
        }
        throw new IllegalArgumentException("Unknown UrlMode: " + urlMode);
    }
}

