/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskState;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskStatus;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nonnull;

public class SimpleMaintenanceTaskStatus
implements MaintenanceTaskStatus,
Serializable {
    private final String cancelToken;
    private final String id;
    private final String memberId;
    private final Progress progress;
    private final String sessionId;
    private final long startTime;
    private final MaintenanceTaskState state;
    private final MaintenanceType type;

    public SimpleMaintenanceTaskStatus(@Nonnull MaintenanceTaskStatus status) {
        this.cancelToken = status.getCancelToken();
        this.id = status.getId();
        this.memberId = status.getOwnerNodeId();
        this.progress = new ProgressImpl(status.getProgress());
        this.sessionId = status.getOwnerSessionId();
        this.type = status.getType();
        this.startTime = status.getStartTime().getTime();
        this.state = status.getState();
    }

    @Nonnull
    public String getCancelToken() {
        return this.cancelToken;
    }

    @Nonnull
    public String getOwnerNodeId() {
        return this.memberId;
    }

    public String getOwnerSessionId() {
        return this.sessionId;
    }

    public boolean isOwner(@Nonnull RequestContext requestContext) {
        Preconditions.checkNotNull((Object)requestContext, (Object)"requestContext");
        return this.sessionId != null && this.sessionId.equals(requestContext.getSessionId());
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Progress getProgress() {
        return this.progress;
    }

    @Nonnull
    public Date getStartTime() {
        return new Date(this.startTime);
    }

    @Nonnull
    public MaintenanceTaskState getState() {
        return this.state;
    }

    @Nonnull
    public MaintenanceType getType() {
        return this.type;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("cancelToken", (Object)this.cancelToken).add("id", (Object)this.id).add("memberId", (Object)this.memberId).add("progress", (Object)this.progress).add("sessionId", (Object)this.sessionId).add("startTime", this.startTime).add("state", (Object)this.state).add("type", (Object)this.type).toString();
    }
}

