/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mail.HtmlCssInliner;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.locale.LocaleUtils;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=SoyMailBuilder.class)
@Component
public class SoyMailBuilderImpl
implements SoyMailBuilder {
    private static final Map<String, Object> SOY_INJECTED_DATA = Collections.singletonMap("productName", Product.NAME);
    private static final Logger log = LoggerFactory.getLogger(SoyMailBuilderImpl.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final HtmlCssInliner htmlCssInliner;
    private final I18nService i18nService;
    private final SecurityService securityService;
    private final InternalLocaleManager localeManager;

    @Autowired
    public SoyMailBuilderImpl(SoyTemplateRenderer soyTemplateRenderer, HtmlCssInliner htmlCssInliner, I18nService i18nService, SecurityService securityService, InternalLocaleManager localeManager) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.htmlCssInliner = htmlCssInliner;
        this.i18nService = i18nService;
        this.securityService = securityService;
        this.localeManager = localeManager;
    }

    public Iterable<MailMessage> build(final @NotNull SoyMailMessageRequest message) {
        Preconditions.checkNotNull((Object)message, (Object)"message");
        return (Iterable)LocaleUtils.withoutLocale((Operation)new UncheckedOperation<Iterable<MailMessage>>(){

            public Iterable<MailMessage> perform() {
                return SoyMailBuilderImpl.this.buildWithNoLocale(message);
            }
        });
    }

    private Iterable<MailMessage> buildWithNoLocale(SoyMailMessageRequest message) {
        HashSet<MailMessage> messages = new HashSet<MailMessage>();
        HashMap localeToMessage = Maps.newHashMap();
        for (ApplicationUser user : Chainable.chain((Iterable)message.getRecipients()).filter(recipient -> StringUtils.isNotBlank((CharSequence)recipient.getEmailAddress()))) {
            Option localeKey = Option.option((Object)this.localeManager.getLocale(user));
            Option<LocalizedMessage> cachedMessage = (Option<LocalizedMessage>)localeToMessage.get(localeKey);
            if (cachedMessage == null) {
                cachedMessage = this.getLocalizedMessage(user, message, (Option<Locale>)localeKey);
                localeToMessage.put(localeKey, cachedMessage);
            }
            for (LocalizedMessage localizedMessage : cachedMessage) {
                MailMessage.Builder mailMessageBuilder = new MailMessage.Builder().to(new String[]{user.getEmailAddress()}).text(localizedMessage.text).subject(localizedMessage.subject).header("Content-Type", "text/html; charset=UTF-8");
                for (Locale locale : localizedMessage.locale) {
                    mailMessageBuilder.header("Content-Language", locale.toLanguageTag());
                }
                mailMessageBuilder = (MailMessage.Builder)message.getMessageEffector().apply(mailMessageBuilder);
                messages.add(mailMessageBuilder.build());
            }
        }
        return messages;
    }

    private Option<LocalizedMessage> getLocalizedMessage(ApplicationUser user, final SoyMailMessageRequest message, final Option<Locale> locale) {
        return (Option)this.securityService.impersonating(user, "Impersonate user for sending mail").call((Operation)new UncheckedOperation<Option<LocalizedMessage>>(){

            public Option<LocalizedMessage> perform() {
                try {
                    String subjectText = null;
                    if (message.getSubjectKey() != null) {
                        I18nKey subjectKey = message.getSubjectKey();
                        subjectText = SoyMailBuilderImpl.this.i18nService.getMessage(subjectKey);
                    }
                    StringWriter writer = new StringWriter();
                    SoyMailBuilderImpl.this.soyTemplateRenderer.render((Appendable)writer, message.getSoyTemplateModuleKey(), message.getSoyTemplateName(), message.getContext(), SOY_INJECTED_DATA);
                    String text = SoyMailBuilderImpl.this.htmlCssInliner.inlineCss(writer.toString(), message.getCssModuleKey());
                    return Option.some((Object)new LocalizedMessage(locale, subjectText, text));
                }
                catch (SoyException e) {
                    log.error("Error rendering email notification ({}/{})", new Object[]{message.getSoyTemplateModuleKey(), message.getSoyTemplateName(), e});
                    return Option.none();
                }
            }
        });
    }

    private static class LocalizedMessage {
        private final Option<Locale> locale;
        private final String subject;
        private final String text;

        private LocalizedMessage(Option<Locale> locale, String subject, String text) {
            this.locale = locale;
            this.subject = subject;
            this.text = text;
        }
    }
}

