/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.bitbucket.event.server.MailHostConfigurationChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mail.MailAttachment;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailQueueFullException;
import com.atlassian.bitbucket.mail.MailSendException;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.MailSizeExceededException;
import com.atlassian.bitbucket.mail.NoMailHostConfigurationException;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.TextUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.PauseableExecutorService;
import com.atlassian.stash.internal.mail.InsufficientSpaceOnMailQueueException;
import com.atlassian.stash.internal.mail.InternalMailService;
import com.atlassian.stash.internal.mail.JavaMailSenderFactory;
import com.atlassian.stash.internal.mail.MailLogger;
import com.atlassian.stash.internal.mail.MailQueueSizeGuard;
import com.atlassian.stash.internal.mail.MailUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.mail.AuthenticationFailedException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Conventions;
import org.springframework.mail.MailAuthenticationException;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.security.access.prepost.PreAuthorize;

public class MailServiceImpl
implements InternalMailService {
    private static final String MAIL_SEND_TIMER = Conventions.getQualifiedAttributeName(MailServiceImpl.class, (String)"sendMessageSynchronously");
    private final ApplicationPropertiesService applicationPropertiesService;
    private final I18nService i18nService;
    private final JavaMailSenderFactory senderFactory;
    private final MailLogger mailLogger;
    private final PauseableExecutorService pauseableExecutorService;
    private final long sendFailurePauseMillis;
    private final int maxMailSize;
    private final CachedReference<Maybe<JavaMailSender>> javaMailSender;
    private int connectTimeout;
    private int sendTimeout;
    private int testConnectTimeout;
    private int testSendTimeout;
    private MailQueueSizeGuard guard;

    public MailServiceImpl(ApplicationPropertiesService propertiesService, I18nService i18nService, JavaMailSenderFactory senderFactory, PauseableExecutorService pauseableExecutorService, MailQueueSizeGuard mailQueueGuard, MailLogger mailLogger, CacheFactory cacheFactory, int sendFailurePauseSeconds, int maxMailSize) {
        Preconditions.checkArgument((sendFailurePauseSeconds >= 0 ? 1 : 0) != 0, (Object)"mail.error.pause.retry is less than 0");
        this.mailLogger = mailLogger;
        this.pauseableExecutorService = pauseableExecutorService;
        this.applicationPropertiesService = propertiesService;
        this.i18nService = i18nService;
        this.senderFactory = senderFactory;
        this.sendFailurePauseMillis = TimeUnit.SECONDS.toMillis(sendFailurePauseSeconds);
        this.maxMailSize = maxMailSize;
        this.guard = mailQueueGuard;
        this.javaMailSender = cacheFactory.getCachedReference(MailService.class, "StashMailConfiguration", (Supplier)new Supplier<Maybe<JavaMailSender>>(){

            public Maybe<JavaMailSender> get() {
                return Option.option((Object)MailServiceImpl.this.buildMailSender(MailServiceImpl.this.applicationPropertiesService.getMailHostConfiguration()));
            }
        }, new CacheSettingsBuilder().replicateViaInvalidation().build());
    }

    public void initMailSender() {
        this.mailLogger.logInfoMessage("Starting mail service", new Object[0]);
        this.javaMailSender.get();
    }

    public void shutdown() {
        this.mailLogger.logInfoMessage("Shutting down mail service", new Object[0]);
        List unprocessedMessages = this.pauseableExecutorService.shutdownNow();
        int unprocessedCount = unprocessedMessages.size();
        if (unprocessedCount > 0) {
            String message = String.format("Discarding %d unsent mail %s", unprocessedCount, TextUtils.pluralise((String)"message", (long)unprocessedCount));
            this.mailLogger.logInfoMessage(message, new Object[0]);
        }
    }

    @Unsecured(value="this needs to be available in all contexts")
    public boolean isHostConfigured() {
        return ((Maybe)this.javaMailSender.get()).isDefined();
    }

    @EventListener
    public void onConfigChanged(MailHostConfigurationChangedEvent event) {
        this.javaMailSender.reset();
        this.mailLogger.logInfoMessage("MailService reconfigured", new Object[0]);
    }

    @Unsecured(value="currently we are not restricting messaging by permission")
    public void submit(final MailMessage mailMessage) throws NoMailHostConfigurationException, MailQueueFullException {
        if (this.isHostConfigured()) {
            this.checkMailSize(mailMessage);
            try {
                final MailQueueSizeGuard.Claim reservation = this.guard.claimSpace(mailMessage);
                this.pauseableExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MailServiceImpl.this.sendNow(mailMessage);
                        }
                        catch (com.atlassian.bitbucket.mail.MailAuthenticationException | MailSendException ex) {
                            MailServiceImpl.this.pauseExecutor();
                        }
                        finally {
                            reservation.release();
                        }
                    }
                });
            }
            catch (InsufficientSpaceOnMailQueueException | RejectedExecutionException ex) {
                this.handleQueueFull(mailMessage, ex);
            }
        } else {
            throw this.throwMailHostConfiguredException(mailMessage);
        }
    }

    private void handleQueueFull(MailMessage mailMessage, Exception ex) {
        KeyedMessage errorMessage = this.i18nService.createKeyedMessage("bitbucket.service.mail.queuefull", new Object[]{mailMessage.getSubject()});
        this.mailLogger.logError(errorMessage.getLocalisedMessage(), mailMessage);
        throw new MailQueueFullException(errorMessage, (Throwable)ex);
    }

    private void pauseExecutor() {
        this.pauseableExecutorService.pauseFor(this.sendFailurePauseMillis, TimeUnit.MILLISECONDS);
    }

    @Unsecured(value="currently we are not restricting messaging by permission")
    public void sendNow(MailMessage message) throws MailException {
        Maybe javaMailSender = (Maybe)this.javaMailSender.get();
        if (javaMailSender.isEmpty()) {
            throw this.throwMailHostConfiguredException(message);
        }
        this.sendMessageSynchronously((JavaMailSender)javaMailSender.get(), message);
    }

    private NoMailHostConfigurationException throwMailHostConfiguredException(MailMessage mailMessage) throws NoMailHostConfigurationException {
        KeyedMessage errorMessage = this.i18nService.createKeyedMessage("bitbucket.service.noemailconfig", new Object[0]);
        NoMailHostConfigurationException e = new NoMailHostConfigurationException(errorMessage);
        this.mailLogger.logError(e.getLocalizedMessage(), mailMessage, (Exception)e);
        throw e;
    }

    private void checkMailSize(MailMessage message) throws MailSizeExceededException {
        int size = MailUtils.computeSize(message);
        if (size > this.maxMailSize) {
            MailSizeExceededException e = new MailSizeExceededException(this.i18nService.createKeyedMessage("bitbucket.service.mailsizeexceeded", new Object[]{size, this.maxMailSize}));
            this.mailLogger.logError(e.getLocalizedMessage(), message, (Exception)e);
            throw e;
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void sendTest(MailHostConfiguration configuration, MailMessage message) throws MailException {
        this.sendMessageSynchronously(this.buildMailSender(configuration, this.testConnectTimeout, this.testSendTimeout), message);
    }

    private void sendMessageSynchronously(JavaMailSender javaMailSender, MailMessage message) throws MailException {
        try (Timer ignored = TimerUtils.start((String)MAIL_SEND_TIMER);){
            this.checkMailSize(message);
            javaMailSender.send(this.newMimeMailMessagePreparator(message));
        }
        catch (MailAuthenticationException e) {
            KeyedMessage errorMessage = this.translateAuthenticationFailure(e);
            this.mailLogger.logError(errorMessage.getLocalisedMessage(), message, (Exception)((Object)e));
            throw new com.atlassian.bitbucket.mail.MailAuthenticationException(errorMessage, (Throwable)e);
        }
        catch (MailSizeExceededException e) {
            throw e;
        }
        catch (Exception e) {
            KeyedMessage errorMessage = this.getSendErrorMessage();
            this.mailLogger.logError(errorMessage.getLocalisedMessage(), message, e);
            throw new MailSendException(errorMessage, (Throwable)e);
        }
        finally {
            this.mailLogger.flush();
        }
    }

    private KeyedMessage translateAuthenticationFailure(MailAuthenticationException e) {
        String message;
        if (e.getCause() instanceof AuthenticationFailedException && (StringUtils.containsIgnoreCase((CharSequence)(message = e.getCause().getMessage()), (CharSequence)"mechansims") || StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"mechanisms"))) {
            return this.i18nService.createKeyedMessage("bitbucket.service.mail.no.mechanisms", new Object[0]);
        }
        return this.getDefaultAuthenticationErrorMessage();
    }

    private KeyedMessage getDefaultAuthenticationErrorMessage() {
        return this.i18nService.createKeyedMessage("bitbucket.service.mail.configurationerror", new Object[0]);
    }

    private KeyedMessage getSendErrorMessage() {
        return this.i18nService.createKeyedMessage("bitbucket.service.mail.sendfail", new Object[0]);
    }

    @Value(value="${mail.timeout.connect}")
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = this.toMilliseconds(connectTimeout);
    }

    @Value(value="${mail.timeout.send}")
    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = this.toMilliseconds(sendTimeout);
    }

    @Value(value="${mail.test.timeout.connect}")
    public void setTestConnectTimeout(int testConnectTimeout) {
        this.testConnectTimeout = this.toMilliseconds(testConnectTimeout);
    }

    @Value(value="${mail.test.timeout.send}")
    public void setTestSendTimeout(int testSendTimeout) {
        this.testSendTimeout = this.toMilliseconds(testSendTimeout);
    }

    private JavaMailSender buildMailSender(MailHostConfiguration config) {
        return this.buildMailSender(config, this.connectTimeout, this.sendTimeout);
    }

    private JavaMailSender buildMailSender(MailHostConfiguration config, int connectTimeout, int sendTimeout) {
        return this.senderFactory.create(config, connectTimeout, sendTimeout);
    }

    private MimeMessagePreparator newMimeMailMessagePreparator(final MailMessage mailMessage) {
        return new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, mailMessage.getAttachments().size() > 0);
                MimeMailMessage message = new MimeMailMessage(helper);
                message.setSubject(mailMessage.getSubject());
                message.setText(mailMessage.getText());
                message.setTo((String[])Iterables.toArray((Iterable)mailMessage.getTo(), String.class));
                if (mailMessage.hasFrom()) {
                    message.setFrom(mailMessage.getFrom());
                } else {
                    InternetAddress from = new InternetAddress(MailServiceImpl.this.applicationPropertiesService.getServerEmailAddress());
                    if (!StringUtils.isBlank((CharSequence)MailServiceImpl.this.applicationPropertiesService.getDisplayName())) {
                        from.setPersonal(MailServiceImpl.this.applicationPropertiesService.getDisplayName());
                    }
                    message.getMimeMessageHelper().setFrom(from);
                }
                if (mailMessage.hasCc()) {
                    message.setCc((String[])Iterables.toArray((Iterable)mailMessage.getCc(), String.class));
                }
                if (mailMessage.hasBcc()) {
                    message.setBcc((String[])Iterables.toArray((Iterable)mailMessage.getBcc(), String.class));
                }
                for (MailAttachment mailAttachment : mailMessage.getAttachments()) {
                    helper.addAttachment(mailAttachment.getFileName(), mailAttachment.getSource());
                }
                for (Map.Entry entry : mailMessage.getHeaders().entrySet()) {
                    mimeMessage.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
        };
    }

    private int toMilliseconds(int seconds) {
        return Ints.checkedCast((long)TimeUnit.SECONDS.toMillis(seconds));
    }
}

