/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.log.LoggingService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryAdapter;
import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.config.log.InternalLoggingService;
import com.atlassian.stash.internal.log.EnhancedLevel;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.hazelcast.internal.monitors.HealthMonitor;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=LoggingService.class)
@Service(value="loggingService")
public class LogbackLoggingService
implements InternalLoggingService,
StatefulService {
    private static final Map<String, Level> DEBUG_LOG_LEVELS = ImmutableMap.builder().put((Object)"ROOT", (Object)Level.INFO).put((Object)"com.atlassian.bitbucket", (Object)Level.DEBUG).put((Object)"com.atlassian.event.remote", (Object)Level.DEBUG).put((Object)"com.atlassian.stash", (Object)Level.DEBUG).put((Object)"org.hibernate", (Object)Level.INFO).put((Object)"org.springframework", (Object)Level.INFO).put((Object)HealthMonitor.class.getName(), (Object)Level.DEBUG).build();
    private static final String MAP_LOGGING_STATE = "logging.state";
    public static final String PREFIX_PROPERTY_GENERIC = "logging.logger.";
    public static final String PREFIX_PROPERTY_LOG4J = "log4j.logger.";
    public static final String PREFIX_ORIGINAL_LOGGER = "__";
    public static final Set<String> PROPERTY_PREFIXES = ImmutableSet.of((Object)"log4j.logger.", (Object)"logging.logger.");
    private final LoggingStateListener listener;
    private final Cache<String, String> loggingState;
    private final ApplicationPropertiesService propertiesService;
    private final I18nService i18nService;
    private final Properties properties;

    @Autowired
    public LogbackLoggingService(CacheFactory cacheFactory, I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties, ApplicationPropertiesService applicationPropertiesService) {
        this.i18nService = i18nService;
        this.properties = properties;
        this.propertiesService = applicationPropertiesService;
        this.listener = new LoggingStateListener();
        this.loggingState = cacheFactory.getCache(MAP_LOGGING_STATE, null, new CacheSettingsBuilder().remote().maxEntries(Integer.MAX_VALUE).build());
        this.loggingState.addListener((CacheEntryListener)this.listener, true);
    }

    @PostConstruct
    public void applyLevelProperties() {
        Collection keys = this.loggingState.getKeys();
        if (keys.isEmpty()) {
            Enumeration<?> propertyNames = this.properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                for (String prefix : PROPERTY_PREFIXES) {
                    String levelName;
                    if (!propertyName.startsWith(prefix) || (levelName = StringUtils.trimToNull((String)this.properties.getProperty(propertyName))) == null) continue;
                    String loggerName = propertyName.substring(prefix.length());
                    this.setLevel(loggerName, levelName);
                }
            }
            if (this.propertiesService.isDebugLoggingEnabled()) {
                this.enableDebugLogging();
            }
        } else {
            for (String key : keys) {
                this.doSetLevel(key, (String)this.loggingState.get((Object)key));
            }
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void disableDebugLogging() {
        for (String loggerName : DEBUG_LOG_LEVELS.keySet()) {
            this.restoreStandardLogLevel(loggerName);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void enableDebugLogging() {
        for (Map.Entry<String, Level> entry : DEBUG_LOG_LEVELS.entrySet()) {
            String loggerName = entry.getKey();
            Level currentLevel = this.getLogbackLevel(loggerName);
            Level desiredLevel = entry.getValue();
            if (desiredLevel.isGreaterOrEqual(currentLevel)) continue;
            this.setLevel(PREFIX_ORIGINAL_LOGGER + loggerName, currentLevel.levelStr);
            this.setLevel(loggerName, desiredLevel.levelStr);
        }
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new MdcState(MDC.getCopyOfContextMap());
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public String getLevel(String loggerName) {
        ch.qos.logback.classic.Logger logger = this.getLogger(loggerName);
        Level effectiveLevel = logger.getEffectiveLevel();
        return effectiveLevel.levelStr;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public String getRootLevel() {
        return this.getLevel("ROOT");
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setLevel(String loggerName, String levelName) {
        String name = StringUtils.trimToNull((String)loggerName);
        if (name == null) {
            String message = this.i18nService.getMessage("bitbucket.logging.logger.name.required", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        this.loggingState.put((Object)name, (Object)levelName);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setRootLevel(String levelName) {
        this.setLevel("ROOT", levelName);
    }

    public void restoreStandardLogLevel(String loggerName) {
        String originalLevel = (String)this.loggingState.get((Object)(PREFIX_ORIGINAL_LOGGER + loggerName));
        if (originalLevel != null) {
            this.loggingState.remove((Object)(PREFIX_ORIGINAL_LOGGER + loggerName));
            this.setLevel(loggerName, originalLevel);
        }
    }

    private void doSetLevel(String name, String levelName) {
        if (name.startsWith(PREFIX_ORIGINAL_LOGGER)) {
            return;
        }
        Level level = this.toLevel(levelName);
        ch.qos.logback.classic.Logger logger = this.getLogger(name);
        Level effectiveLevel = logger.getEffectiveLevel();
        if (!effectiveLevel.equals(level)) {
            EnhancedLevel.fromLevel(effectiveLevel).log((Logger)logger, "Switching to log level [{}]", levelName);
            logger.setLevel(level);
        }
    }

    private ch.qos.logback.classic.Logger getLogger(String name) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        return lc.getLogger(name);
    }

    private Level getLogbackLevel(String loggerName) {
        return this.getLogger(loggerName).getEffectiveLevel();
    }

    @PreDestroy
    private void onShutdown() {
        this.loggingState.removeListener((CacheEntryListener)this.listener);
    }

    private Level toLevel(String levelName) {
        Level level = Level.toLevel((String)levelName, null);
        if (level == null) {
            String message = this.i18nService.getMessage("bitbucket.logging.level.invalid", new Object[]{levelName});
            throw new IllegalArgumentException(message);
        }
        return level;
    }

    private class LoggingStateListener
    extends CacheEntryAdapter<String, String> {
        private LoggingStateListener() {
        }

        public void onAdd(@Nonnull CacheEntryEvent<String, String> event) {
            LogbackLoggingService.this.doSetLevel((String)event.getKey(), (String)event.getValue());
        }

        public void onEvict(@Nonnull CacheEntryEvent<String, String> event) {
            LogbackLoggingService.this.restoreStandardLogLevel((String)event.getKey());
        }

        public void onRemove(@Nonnull CacheEntryEvent<String, String> event) {
            LogbackLoggingService.this.restoreStandardLogLevel((String)event.getKey());
        }

        public void onUpdate(@Nonnull CacheEntryEvent<String, String> event) {
            LogbackLoggingService.this.doSetLevel((String)event.getKey(), (String)event.getValue());
        }
    }

    private static final class MdcState
    implements TransferableState {
        private final Map<String, String> state;

        private MdcState(Map<String, String> state) {
            this.state = state;
        }

        public void apply() {
            if (this.state != null) {
                MDC.setContextMap(this.state);
            }
        }

        public void remove() {
            MDC.clear();
        }
    }
}

