/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.idx.CommitPropertyConfiguration;
import com.atlassian.bitbucket.idx.CommitPropertyConfigurationModuleDescriptor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluggableCommitPropertyConfiguration
implements CommitPropertyConfiguration {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluggableCommitPropertyConfiguration(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public Collection<String> getPropertiesToPreload(Repository repository) {
        ImmutableSet.Builder properties = ImmutableSet.builder();
        this.getModules(CommitPropertyConfigurationModuleDescriptor.class).forEach(config -> properties.addAll((Iterable)config.getPropertiesToPreload(repository)));
        return properties.build();
    }

    private <M, MD extends ModuleDescriptor<M>> Stream<M> getModules(Class<MD> descriptorClass) {
        return ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(descriptorClass));
    }
}

