/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.IndexSearchRequest;
import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.permission.PermissionPredicateFactory;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.content.IndexedCommitDao;
import com.atlassian.stash.internal.idx.InternalIndexedCommit;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=CommitIndex.class)
@Component(value="commitIndex")
@Transactional(readOnly=true)
public class DefaultCommitIndex
implements CommitIndex {
    private final Predicate<Repository> canReadRepositoryPredicate;
    private final IndexedCommitDao commitDao;
    @Value(value="${page.max.index.results}")
    private int maxIndexResults;

    @Autowired
    public DefaultCommitIndex(IndexedCommitDao commitDao, PermissionPredicateFactory predicateFactory) {
        this.canReadRepositoryPredicate = predicateFactory.createRepositoryAccessiblePredicate();
        this.commitDao = commitDao;
    }

    @Transactional
    public void addCommit(@Nonnull Commit commit, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)commit, (Object)"commit");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        InternalIndexedCommit indexedCommit = (InternalIndexedCommit)this.commitDao.getById((Object)commit.getId());
        if (indexedCommit == null) {
            indexedCommit = new InternalIndexedCommit(commit.getId(), commit.getAuthorTimestamp());
            this.commitDao.create((Object)indexedCommit);
        }
        if (!DefaultCommitIndex.isPersonalFork(repository)) {
            this.commitDao.addMembership(indexedCommit, InternalConverter.convertToInternalRepository((Repository)repository));
        }
    }

    @Transactional
    public void addProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.commitDao.addProperty((InternalIndexedCommit)this.commitDao.getById((Object)commitId), key, value);
    }

    @Nonnull
    public Page<IndexedCommit> findByProperty(final @Nonnull String propertyKey, final @Nonnull String propertyValue, final boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)propertyKey, (Object)"propertyKey");
        Preconditions.checkNotNull((Object)propertyValue, (Object)"propertyValue");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxIndexResults);
        PageProvider<IndexedCommit> pageProvider = new PageProvider<IndexedCommit>(){

            public Page<IndexedCommit> get(PageRequest request) {
                return DefaultCommitIndex.this.commitDao.findByProperty(propertyKey, propertyValue, caseSensitive, request).transform(commit -> DefaultCommitIndex.this.transformForPermissions(commit));
            }
        };
        return PageUtils.filterPages((PageProvider)pageProvider, commit -> !commit.getRepositories().isEmpty(), (PageRequest)pageRequest);
    }

    public IndexedCommit getCommit(@Nonnull String commitId) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        IndexedCommit commit = (IndexedCommit)this.commitDao.getById((Object)commitId);
        if (commit != null) {
            if (Iterables.any((Iterable)commit.getRepositories(), this.canReadRepositoryPredicate::test)) {
                return commit;
            }
        }
        return null;
    }

    @Nonnull
    public PropertyMap getProperties(@Nonnull String commitId, @Nonnull Iterable<String> propertyKeys) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull(propertyKeys, (Object)"propertyKeys");
        return this.commitDao.getProperties(commitId, propertyKeys);
    }

    @Nonnull
    public Map<String, PropertyMap> getProperties(@Nonnull Iterable<String> commitIds, @Nonnull Iterable<String> propertyKeys) {
        Preconditions.checkNotNull(commitIds, (Object)"commitIds");
        Preconditions.checkNotNull(propertyKeys, (Object)"propertyKeys");
        return this.commitDao.getProperties(commitIds, propertyKeys);
    }

    public boolean isIndexed(@Nonnull String commitId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        return this.canReadRepositoryPredicate.test(repository) && this.commitDao.isIndexed(commitId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Transactional
    public void removeCommit(@Nonnull String commitId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        this.commitDao.deleteMembership(commitId, InternalConverter.convertToInternalRepository((Repository)repository));
    }

    @Transactional
    public void removeProperty(@Nonnull String commitId, @Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.commitDao.removeProperty(commitId, key, value);
    }

    @Nonnull
    public Page<IndexedCommit> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)searchRequest, (Object)"searchRequest");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return PageUtils.asPageOf(IndexedCommit.class, (Page)this.commitDao.search(searchRequest, pageRequest));
    }

    private static boolean isPersonalFork(Repository repository) {
        return repository.isFork() && repository.getProject().getType() == ProjectType.PERSONAL;
    }

    private IndexedCommit transformForPermissions(final InternalIndexedCommit commit) {
        final Set repositories = Chainable.chain((Iterable)commit.getRepositories()).filter(this.canReadRepositoryPredicate).toSet();
        return new IndexedCommit(){

            @Nonnull
            public String getId() {
                return commit.getId();
            }

            @Nonnull
            public Date getAuthorTimestamp() {
                return commit.getAuthorTimestamp();
            }

            @Nonnull
            public Set<Repository> getRepositories() {
                return repositories;
            }
        };
    }
}

