/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.stash.internal.i18n.LocaleBuilder;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class CriticalLocaleHolder
implements ApplicationListener<ContextRefreshedEvent>,
LocaleHolder {
    private volatile LocaleHolder localeHolder;

    @Nonnull
    public Iterable<Locale> getLocales(Locale ... overrides) {
        if (this.localeHolder == null) {
            return new LocaleBuilder().addAll(Arrays.asList(overrides)).add(Locale.US).build();
        }
        return this.localeHolder.getLocales(overrides);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.localeHolder == null) {
            this.localeHolder = (LocaleHolder)event.getApplicationContext().getBean("localeHolder", LocaleHolder.class);
        }
    }
}

