/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.PropertiesUtils;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.fugue.Option;
import com.atlassian.hazelcast.serialization.OsgiClassLoaderRegistrySynchronizer;
import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.hazelcast.serialization.OsgiSafeStreamSerializer;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.auth.trusted.InternalCurrentApplication;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplication;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplicationRestriction;
import com.atlassian.stash.internal.cluster.ClusterNodeNameResolver;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.hazelcast.ClusterJoinSocketInterceptor;
import com.atlassian.stash.internal.hazelcast.HighestPlusOneMergePolicy;
import com.atlassian.stash.internal.hazelcast.LicenseStreamSerializer;
import com.atlassian.stash.internal.hazelcast.OptionStreamSerializer;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.license.LicensedUserCountCache;
import com.atlassian.stash.internal.license.SimpleDualLicense;
import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.InternalRepositoryPushActivity;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalPermissionType;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.instance.Capability;
import com.hazelcast.map.merge.LatestUpdateMapMergePolicy;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.spring.context.SpringManagedContext;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class HazelcastConfigFactoryBean
implements FactoryBean<Config> {
    private static final Logger log = LoggerFactory.getLogger(HazelcastConfigFactoryBean.class);
    private final ApplicationContext applicationContext;
    private final LicenseHelper licenseHelper;
    private final OsgiSafeStreamSerializer osgiSafeStreamSerializer;
    private final Properties properties;
    @Value(value="${hazelcast.jmx.detailed}")
    private boolean jmxDetailed;
    @Value(value="${jmx.enabled}")
    private boolean jmxEnabled;
    @Value(value="${hazelcast.group.name}")
    private String groupName;
    @Value(value="${hazelcast.group.password}")
    private String groupPassword;
    @Value(value="${hazelcast.port}")
    private int networkPort;
    @Value(value="${hazelcast.network.aws}")
    private boolean networkAwsEnabled;
    @Value(value="#{${hazelcast.network.multicast}}")
    private boolean networkMulticastEnabled;
    @Value(value="${hazelcast.network.tcpip}")
    private boolean networkTcpIpEnabled;
    @Value(value="${hazelcast.statistics.enabled}")
    private boolean statisticsEnabled;
    @Value(value="${application.mode}")
    private String applicationMode;

    @Autowired
    public HazelcastConfigFactoryBean(ApplicationContext applicationContext, LicenseHelper licenseHelper, OsgiSafeStreamSerializer osgiSafeStreamSerializer, @Qualifier(value="applicationProperties") Properties properties) {
        this.applicationContext = applicationContext;
        this.licenseHelper = licenseHelper;
        this.osgiSafeStreamSerializer = osgiSafeStreamSerializer;
        this.properties = properties;
    }

    public Config getObject() throws Exception {
        SpringManagedContext managedContext = new SpringManagedContext();
        managedContext.setApplicationContext(this.applicationContext);
        Config config = new Config("hazelcast");
        config.setCapabilities(EnumSet.noneOf(Capability.class));
        config.setManagedContext((ManagedContext)managedContext);
        config.setClassLoader(this.getClass().getClassLoader());
        this.configureAttributes(config);
        this.configureGroup(config);
        this.configureJmx(config);
        this.configureEnterprise(config);
        this.configureNetwork(config.getNetworkConfig());
        this.configureSerialization(config.getSerializationConfig());
        this.configureCaches(config);
        this.configureExecutors(config);
        this.configureMaps(config);
        this.configureScheduler(config);
        return config;
    }

    private void configureJmx(Config config) {
        config.setProperty("hazelcast.jmx", Boolean.toString(this.jmxEnabled));
        config.setProperty("hazelcast.jmx.detailed", Boolean.toString(this.jmxEnabled && this.jmxDetailed));
    }

    public Class<?> getObjectType() {
        return Config.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private MapConfig boundedCache(Class<?> entityClass) {
        return this.boundedCache(entityClass.getName());
    }

    private MapConfig boundedCache(Class<?> entityClass, String field) {
        String name = entityClass.getName();
        if (StringUtils.isNotBlank((CharSequence)field)) {
            name = name + "." + field;
            if (ReflectionUtils.findField(entityClass, (String)field) == null) {
                throw new IllegalStateException(name + " field does not exist. Please update the cache configuration");
            }
        }
        return this.boundedCache(name);
    }

    private MapConfig boundedCache(String name) {
        return this.boundedCache(name, true);
    }

    private MapConfig boundedCache(String name, boolean nearCache) {
        int timeToIdleSeconds = this.getInt("cache." + name + ".tti", 0);
        int timeToLiveSeconds = this.getInt("cache." + name + ".ttl", 0);
        return this.boundedCache(name, this.getMaxOrFail("cache." + name + ".max"), timeToLiveSeconds, timeToIdleSeconds, nearCache);
    }

    private MapConfig boundedCache(String name, int size, int timeToLive, int timeToIdle, boolean nearCache) {
        size = this.normalizeSize(size);
        MapConfig config = new MapConfig(name).setBackupCount(0).setEvictionPolicy(EvictionPolicy.LFU).setMaxIdleSeconds(Math.max(0, timeToIdle)).setMaxSizeConfig(new MaxSizeConfig(size, MaxSizeConfig.MaxSizePolicy.PER_NODE)).setMinEvictionCheckMillis(0L).setStatisticsEnabled(this.statisticsEnabled).setTimeToLiveSeconds(Math.max(0, timeToLive));
        if (nearCache) {
            config.setNearCacheConfig(this.defaultNearCacheConfig().setEvictionPolicy(EvictionPolicy.LFU.name()).setMaxSize(size).setMaxIdleSeconds(Math.max(0, timeToIdle))).setTimeToLiveSeconds(Math.max(0, timeToLive));
        }
        return config;
    }

    private void configureAttributes(Config config) {
        MemberAttributeConfig attributeConfig = new MemberAttributeConfig();
        attributeConfig.setStringAttribute("node.vm.id", UUID.randomUUID().toString());
        attributeConfig.setStringAttribute("node.name", ClusterNodeNameResolver.getNodeName());
        config.setMemberAttributeConfig(attributeConfig);
    }

    private void configureCaches(Config config) {
        OsgiClassLoaderRegistrySynchronizer.configure((Config)config);
        config.addMapConfig(new MapConfig("org.hibernate.cache.spi.UpdateTimestampsCache").setBackupCount(0).setMergePolicy(LatestUpdateMapMergePolicy.class.getName()).setNearCacheConfig(this.defaultNearCacheConfig()).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(this.boundedCache("query.*", false));
        config.addMapConfig(this.boundedCache("org.hibernate.cache.internal.StandardQueryCache"));
        config.addMapConfig(this.boundedCache("query.cwdUserByDirectory"));
        config.addMapConfig(this.boundedCache("query.groupMemberships"));
        config.addMapConfig(this.boundedCache("query.permissions"));
        config.addMapConfig(this.boundedCache("query.projects"));
        config.addMapConfig(this.boundedCache("query.publicRepositoryCountByProject"));
        config.addMapConfig(this.boundedCache("query.pullRequestCountByUser"));
        config.addMapConfig(this.boundedCache("query.pullRequestParticipantUsers"));
        config.addMapConfig(this.boundedCache("query.repositoriesByHierarchy"));
        config.addMapConfig(this.boundedCache("query.repositoryBySlug"));
        config.addMapConfig(this.boundedCache(PluginSetting.class.getName() + "##NaturalId"));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class, "attributes"));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class, "directoryMappings"));
        config.addMapConfig(this.boundedCache(ApplicationImpl.class, "remoteAddresses"));
        config.addMapConfig(this.boundedCache(DirectoryImpl.class));
        config.addMapConfig(this.boundedCache(DirectoryImpl.class, "allowedOperations"));
        config.addMapConfig(this.boundedCache(DirectoryImpl.class, "attributes"));
        config.addMapConfig(this.boundedCache(DirectoryMapping.class));
        config.addMapConfig(this.boundedCache(DirectoryMapping.class, "authorisedGroups"));
        config.addMapConfig(this.boundedCache(DirectoryMapping.class, "allowedOperations"));
        config.addMapConfig(this.boundedCache(GroupMapping.class));
        config.addMapConfig(this.boundedCache(InternalUser.class));
        config.addMapConfig(this.boundedCache(InternalUser.class, "credentialRecords"));
        config.addMapConfig(this.boundedCache(Property.class));
        config.addMapConfig(this.boundedCache(InternalActivity.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalComment.class));
        config.addMapConfig(this.boundedCache(InternalComment.class, "comments"));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussion.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussion.class, "participants"));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussion.class, "watchers"));
        config.addMapConfig(this.boundedCache(InternalCommitDiscussionParticipant.class));
        config.addMapConfig(this.boundedCache(InternalCurrentApplication.class));
        config.addMapConfig(this.boundedCache(InternalDiffCommentAnchor.class));
        config.addMapConfig(this.boundedCache(InternalPermissionType.class));
        config.addMapConfig(this.boundedCache(PluginSetting.class));
        config.addMapConfig(this.boundedCache(InternalProject.class));
        config.addMapConfig(this.boundedCache(InternalPullRequest.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalPullRequest.class, "participants"));
        config.addMapConfig(this.boundedCache(InternalPullRequest.class, "watchers"));
        config.addMapConfig(this.boundedCache(InternalPullRequestParticipant.class));
        config.addMapConfig(this.boundedCache(InternalPullRequestRescopeActivity.class, "commits").setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalRepository.class));
        config.addMapConfig(this.boundedCache(InternalRepositoryHook.class).setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalRepositoryPushActivity.class, "refChanges").setNearCacheConfig(null));
        config.addMapConfig(this.boundedCache(InternalApplicationUser.class));
        config.addMapConfig(this.boundedCache(InternalTask.class));
        config.addMapConfig(this.boundedCache(InternalTrustedApplication.class));
        config.addMapConfig(this.boundedCache(InternalTrustedApplication.class, "restrictions"));
        config.addMapConfig(this.boundedCache(InternalTrustedApplicationRestriction.class));
        config.addMapConfig(this.boundedCache(InternalUserSettings.class));
        config.addMapConfig(this.boundedCache(InternalWatcher.class));
        config.addMapConfig(new MapConfig("atlassian-cache.*").setBackupCount(0).setNearCacheConfig(this.defaultNearCacheConfig()).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(this.boundedCache("atlassian-cache.Cache." + ApplicationPropertiesService.class.getName(), 0, 0, 0, true));
        config.addMapConfig(this.boundedCache("atlassian-cache.CacheReference." + LicenseService.class.getName() + ".BitbucketServerLicense", 0, 0, 0, true));
        config.addMapConfig(this.boundedCache(LicensedUserCountCache.class));
        config.addMapConfig(this.boundedCache(RepositoryService.class));
        config.addMapConfig(this.boundedCache("cache.permissionGraph.defaultPermissions", 0, 0, 0, true));
        config.addMapConfig(this.boundedCache("cache.permissionGraph.groupPermissions", this.getMaxOrFail("permissions.cache.groups.max"), 0, 0, true));
        config.addMapConfig(this.boundedCache("cache.permissionGraph.userPermissions", this.getMaxOrFail("permissions.cache.users.max"), 0, 0, true));
        config.addMapConfig(new MapConfig("versiontracker.*").setBackupCount(1).setMergePolicy(HighestPlusOneMergePolicy.class.getName()).setStatisticsEnabled(this.statisticsEnabled));
    }

    private void configureEnterprise(Config config) {
        String managementCenterUrl;
        String license = this.properties.getProperty("hazelcast.enterprise.license");
        if (StringUtils.isNotBlank((CharSequence)license)) {
            config.setLicenseKey(license);
        }
        if (StringUtils.isNotBlank((CharSequence)(managementCenterUrl = this.properties.getProperty("hazelcast.managementcenter.url")))) {
            config.setManagementCenterConfig(new ManagementCenterConfig().setEnabled(true).setUrl(managementCenterUrl));
        }
    }

    private void configureExecutors(Config config) {
        int poolSize = PropertiesUtils.parseExpression((String)this.properties.getProperty("hazelcast.executor.max.threads"), (int)16);
        int queueCapacity = PropertiesUtils.parseExpression((String)this.properties.getProperty("hazelcast.executor.queue.size"), (int)0);
        ExecutorConfig executorConfig = new ExecutorConfig("bitbucket.core", poolSize).setQueueCapacity(queueCapacity).setStatisticsEnabled(this.statisticsEnabled);
        config.addExecutorConfig(executorConfig);
    }

    private void configureGroup(Config config) {
        config.setGroupConfig(new GroupConfig(this.groupName, this.groupPassword));
        config.setProperty("hazelcast.graceful.shutdown.max.wait", this.properties.getProperty("hazelcast.graceful.shutdown.max.wait"));
        config.setProperty("hazelcast.health.monitoring.level", this.properties.getProperty("hazelcast.health.monitoring.level"));
        config.setProperty("hazelcast.health.monitoring.delay.seconds", this.properties.getProperty("hazelcast.health.monitoring.delay"));
        config.setProperty("hazelcast.max.no.heartbeat.seconds", this.properties.getProperty("hazelcast.max.no.heartbeat"));
        config.setProperty("hazelcast.operation.call.timeout.millis", this.properties.getProperty("hazelcast.operation.call.timeout"));
        config.setProperty("hazelcast.partition.backup.sync.interval", Long.toString(TimeUnit.MINUTES.toSeconds(this.getIntOrFail("hazelcast.backup.sync.interval"))));
        config.setProperty("hazelcast.version.check.enabled", this.properties.getProperty("hazelcast.version.check.enabled"));
    }

    private void configureMaps(Config config) {
        config.addMapConfig(new MapConfig("default").setBackupCount(1).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig(HttpSession.class.getName()).setAsyncBackupCount(1).setBackupCount(0).setNearCacheConfig(this.defaultNearCacheConfig()).setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("bucketed.executor.tasks").setAsyncBackupCount(1).setBackupCount(0).setStatisticsEnabled(this.statisticsEnabled).setInMemoryFormat(InMemoryFormat.OBJECT));
        config.addMapConfig(new MapConfig("com.atlassian.stash.internal.pull.PendingUpdatesCount").setAsyncBackupCount(1).setBackupCount(0).setStatisticsEnabled(this.statisticsEnabled));
    }

    private void configureNetwork(NetworkConfig config) {
        if (this.networkMulticastEnabled && this.networkTcpIpEnabled) {
            log.warn("Both TCP/IP and Multicast have been enabled for Hazelcast node discovery. Setting to default TCP/IP");
            this.networkMulticastEnabled = false;
        }
        boolean clusteringEnabled = this.licenseHelper.isClusteringEnabled(false) && ApplicationMode.fromId((String)this.applicationMode).orElse(ApplicationMode.DEFAULT) != ApplicationMode.MIRROR;
        JoinConfig joinConfig = config.getJoin();
        AwsConfig awsConfig = joinConfig.getAwsConfig();
        awsConfig.setEnabled(clusteringEnabled && this.networkAwsEnabled);
        if (awsConfig.isEnabled()) {
            String awsAccessKey = this.properties.getProperty("hazelcast.network.aws.access.key");
            String awsSecretKey = this.properties.getProperty("hazelcast.network.aws.secret.key");
            String awsRegion = this.properties.getProperty("hazelcast.network.aws.region");
            String awsHostHeader = this.properties.getProperty("hazelcast.network.aws.host.header");
            String awsSecurityGroupName = this.properties.getProperty("hazelcast.network.aws.security.group.name");
            String awsTagKey = this.properties.getProperty("hazelcast.network.aws.tag.key");
            String awsTagValue = this.properties.getProperty("hazelcast.network.aws.tag.value");
            Optional<Integer> awsTimeout = this.getTimeout("hazelcast.network.aws.connection.timeout.seconds");
            awsConfig.setAccessKey(awsAccessKey);
            awsConfig.setSecretKey(awsSecretKey);
            awsTimeout.ifPresent(arg_0 -> ((AwsConfig)awsConfig).setConnectionTimeoutSeconds(arg_0));
            if (StringUtils.isNotEmpty((CharSequence)awsRegion)) {
                awsConfig.setRegion(awsRegion);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsHostHeader)) {
                awsConfig.setHostHeader(awsHostHeader);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsSecurityGroupName)) {
                awsConfig.setSecurityGroupName(awsSecurityGroupName);
            }
            if (StringUtils.isNotEmpty((CharSequence)awsTagKey)) {
                awsConfig.setTagKey(awsTagKey);
                awsConfig.setTagValue(awsTagValue);
            }
        }
        MulticastConfig multicastConfig = joinConfig.getMulticastConfig();
        multicastConfig.setEnabled(clusteringEnabled && this.networkMulticastEnabled);
        if (multicastConfig.isEnabled()) {
            String multicastAddress = this.properties.getProperty("hazelcast.network.multicast.address");
            int multicastPort = this.getInt("hazelcast.network.multicast.port", 54327);
            Optional<Integer> multicastTimeout = this.getTimeout("hazelcast.network.multicast.timeout.seconds");
            Optional<Integer> multicastTtl = this.getTtl("hazelcast.network.multicast.ttl");
            multicastConfig.setMulticastPort(multicastPort);
            multicastTimeout.ifPresent(arg_0 -> ((MulticastConfig)multicastConfig).setMulticastTimeoutSeconds(arg_0));
            multicastTtl.ifPresent(arg_0 -> ((MulticastConfig)multicastConfig).setMulticastTimeToLive(arg_0));
            if (StringUtils.isNotBlank((CharSequence)multicastAddress)) {
                multicastConfig.setMulticastGroup(multicastAddress);
            }
        }
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        tcpIpConfig.setEnabled(clusteringEnabled && this.networkTcpIpEnabled);
        if (tcpIpConfig.isEnabled()) {
            String tcpIpMembers = this.properties.getProperty("hazelcast.network.tcpip.members");
            Optional<Integer> tcpIpTimeout = this.getTimeout("hazelcast.network.tcpip.connection.timeout.seconds");
            tcpIpTimeout.ifPresent(arg_0 -> ((TcpIpConfig)tcpIpConfig).setConnectionTimeoutSeconds(arg_0));
            if (StringUtils.isNotBlank((CharSequence)tcpIpMembers)) {
                tcpIpConfig.addMember(tcpIpMembers);
            }
        }
        config.setPort(this.networkPort);
        if (clusteringEnabled) {
            SocketInterceptorConfig interceptorConfig = new SocketInterceptorConfig();
            interceptorConfig.setClassName(ClusterJoinSocketInterceptor.class.getName());
            interceptorConfig.setEnabled(true);
            config.setSocketInterceptorConfig(interceptorConfig);
        }
    }

    private void configureScheduler(Config config) {
        config.addMapConfig(new MapConfig("quartz.jobStore.calendars").setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("quartz.jobStore.jobs").setStatisticsEnabled(this.statisticsEnabled));
        config.addMapConfig(new MapConfig("quartz.jobStore.triggers").setStatisticsEnabled(this.statisticsEnabled).setMapIndexConfigs((List)ImmutableList.of((Object)new MapIndexConfig("jobGroup", false), (Object)new MapIndexConfig("jobName", false), (Object)new MapIndexConfig("nextFireTime", false), (Object)new MapIndexConfig("state", false))));
    }

    private void configureSerialization(SerializationConfig config) {
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)this.osgiSafeStreamSerializer).setTypeClass(OsgiSafe.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new LicenseStreamSerializer(this.licenseHelper)).setTypeClass(SimpleDualLicense.class));
        config.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new OptionStreamSerializer()).setTypeClass(Option.class));
    }

    private NearCacheConfig defaultNearCacheConfig() {
        return new NearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT).setCacheLocalEntries(true);
    }

    private int getInt(String propertyName, int defaultValue) {
        String maxSize = this.properties.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)maxSize)) {
            return defaultValue;
        }
        return Integer.parseInt(maxSize);
    }

    private int getIntOrFail(String propertyName) {
        String maxSize = this.properties.getProperty(propertyName);
        Preconditions.checkState((!StringUtils.isBlank((CharSequence)maxSize) ? 1 : 0) != 0, (String)"Property '{}' is undefined", (Object[])new Object[]{propertyName});
        return Integer.parseInt(maxSize);
    }

    private int getMaxOrFail(String propertyName) {
        int configured = this.getIntOrFail(propertyName);
        int normalized = this.normalizeSize(configured);
        if (configured != 0 && configured != normalized) {
            log.warn("Ignoring \"{}={}\"; values less than 500, except 0, are not valid", (Object)propertyName, (Object)configured);
        }
        return normalized;
    }

    private Optional<Integer> getTimeout(String propertyName) {
        String value = this.properties.getProperty(propertyName, "-1");
        try {
            int timeout = Integer.parseInt(value);
            if (timeout > -1) {
                return Optional.of(timeout);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Ignoring \"{}={}\"; timeouts must be numbers", (Object)propertyName, (Object)value);
        }
        return Optional.empty();
    }

    private Optional<Integer> getTtl(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        try {
            int ttl = Integer.parseInt(value.trim());
            if (ttl >= 0 || ttl <= 255) {
                return Optional.of(ttl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        log.warn("Ignoring \"{}={}\"; TTLs must be a number between 0 and 255", (Object)propertyName, (Object)value);
        return Optional.empty();
    }

    private int normalizeSize(int size) {
        if (size <= 0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(size, 500);
    }
}

