/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.comment.AddDiffCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.comment.NoSuchCommentException;
import com.atlassian.bitbucket.commit.BatchingCommitCallback;
import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.ChangesetsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionCommentAnchor;
import com.atlassian.bitbucket.commit.CommitEnricher;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.CommitsRequest;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalRequest;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesetsCommandParameters;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentCountChangeCallback;
import com.atlassian.stash.internal.comment.CommentCountChangeTransform;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.commit.CommitDiscussionRequest;
import com.atlassian.stash.internal.commit.CommitDiscussionSource;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitService;
import com.atlassian.stash.internal.commit.graph.CommitGraphSource;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.content.comment.InternalCommitDiscussionCommentHelper;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=CommitService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="commitService")
public class DefaultCommitService
extends AbstractScmService
implements InternalCommitService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommitService.class);
    private final InternalCommitDiscussionCommentHelper commentHelper;
    private final CommitDiscussionSource discussionSource;
    private final CommitEnricher enricher;
    private final CommitGraphSource graphSource;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final InternalWatcherService watcherService;
    @Value(value="${commit.message.max}")
    private int maxMessageLength;

    @Autowired
    public DefaultCommitService(CommitEnricher enricher, InternalCommitDiscussionCommentHelper commentHelper, CommitDiscussionSource discussionSource, CommitGraphSource graphSource, I18nService i18nService, ScmService scmService, PermissionService permissionService, InternalWatcherService watcherService) {
        super(scmService);
        this.commentHelper = commentHelper;
        this.discussionSource = discussionSource;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.graphSource = graphSource;
        this.watcherService = watcherService;
        this.enricher = enricher;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addComment(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.create((InternalCommentable)this.getDiscussion(repository, commitId, true, true), commentText);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addDiffComment(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull AddDiffCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.commentHelper.createDiffComment((InternalCommentable)this.getDiscussion(repository, commitId, true, true), request);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addFileComment(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull AddFileCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.commentHelper.createFileComment((InternalCommentable)this.getDiscussion(repository, commitId, true, true), request);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addReply(@Nonnull Repository repository, @Nonnull String commitId, long commentId, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.createReply((InternalCommentable)this.getDiscussionOrNoComment(repository, commitId, true), commentId, commentText);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public boolean deleteComment(@Nonnull Repository repository, @Nonnull String commitId, long commentId, int commentVersion) {
        InternalCommitDiscussion discussion = this.findDiscussionById(repository, commitId);
        return discussion != null && this.commentHelper.delete((InternalCommentable)discussion, commentId, commentVersion);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public Iterable<DiffCommentAnchor> findCommentAnchors(@Nonnull Repository repository, @Nonnull String commitId, String parentId, @Nonnull String path) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)path, (Object)"path")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank path is required");
        InternalCommitDiscussion discussion = this.findDiscussionById(repository, commitId);
        if (discussion == null) {
            return Collections.emptyList();
        }
        return this.commentHelper.findDiffAnchors(discussion, parentId, path);
    }

    public InternalCommitDiscussion findDiscussionById(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.getDiscussion(repository, commitId, false, false);
    }

    @PreAuthorize(value="hasRepositoryPermission(#discussion.repository, 'REPO_READ')")
    public CommitDiscussionCommentAnchor getAnchorByComment(@Nonnull CommitDiscussion discussion, long commentId) {
        Preconditions.checkNotNull((Object)discussion, (Object)"discussion");
        return this.commentHelper.getAnchorByComment(InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)discussion), commentId);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<Change> getChanges(@Nonnull ChangesRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChanges);
        ChangesCommandParameters parameters = ((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder(request).maxChanges(this.maxChanges)).build();
        Page page = (Page)this.getCommandFactory(request.getRepository()).changes(parameters, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        } else {
            Map<InternalChangeLocation, CommentCounts> countsByLocation = this.getCountsByLocation(request);
            if (!countsByLocation.isEmpty()) {
                page = page.transform((Function)new CommentCountChangeTransform(countsByLocation));
            }
        }
        return page;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<Changeset> getChangesets(@Nonnull ChangesetsRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Page page = (Page)this.getCommandFactory(request.getRepository()).changesets(new ChangesetsCommandParameters.Builder().commitIds(request.getCommitIds()).maxChangesPerCommit(Math.min(request.getMaxChangesPerCommit(), this.maxChanges)).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).ignoreMissing(request.isIgnoreMissing()).build(), pageRequest).call();
        if (page == null) {
            page = PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return page;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public Comment getComment(@Nonnull Repository repository, @Nonnull String commitId, long commentId) {
        return this.commentHelper.getById((InternalCommentable)this.getDiscussionOrNoComment(repository, commitId, false), commentId);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Commit getCommit(@Nonnull CommitRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Repository repository = request.getRepository();
        String commitId = request.getCommitId();
        Commit commit = (Commit)this.getCommandFactory(repository).commit(new CommitCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build()).call();
        if (commit == null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{repository.getName(), commitId}), commitId);
        }
        return this.enricher.enrich(repository, commit, (Collection)request.getPropertyKeys());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<Commit> getCommits(@Nonnull CommitsRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Repository repository = request.getRepository();
        Page commits = (Page)this.getCommandFactory(repository).commits(new CommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), pageRequest).call();
        if (commits == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.enricher.enrichPage(repository, commits, (Collection)request.getPropertyKeys());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public Page<Commit> getCommitsBetween(@Nonnull CommitsBetweenRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Repository repository = request.getRepository();
        Page commits = (Page)this.getCommandFactory(repository).commits(new CommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), pageRequest).call();
        if (commits == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.enricher.enrichPage(repository, commits, (Collection)request.getPropertyKeys());
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void streamChanges(@Nonnull ChangesRequest request, @Nonnull ChangeCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Map<InternalChangeLocation, CommentCounts> countsByLocation = this.getCountsByLocation(request);
        if (!countsByLocation.isEmpty()) {
            callback = new CommentCountChangeCallback(callback, countsByLocation);
        }
        this.getCommandFactory(request.getRepository()).changes(((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder(request).maxChanges(this.maxChanges)).build(), callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void streamCommits(@Nonnull CommitsRequest request, @Nonnull CommitCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), this.enrichingCallback(callback, request.getRepository(), request.getPropertyKeys())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public void streamCommitsBetween(@Nonnull CommitsBetweenRequest request, @Nonnull CommitCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), this.enrichingCallback(callback, request.getRepository(), request.getPropertyKeys())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void streamDiff(@Nonnull DiffRequest request, @Nonnull DiffContentCallback callback) {
        InternalCommitDiscussion discussion;
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)request, (Object)"callback");
        ImmutableSet.Builder pathsBuilder = ImmutableSet.builder();
        pathsBuilder.addAll((Iterable)request.getPaths());
        if (request.isWithAutoSrcPath()) {
            this.resolveSrcPath(request).ifPresent(arg_0 -> ((ImmutableSet.Builder)pathsBuilder).add(arg_0));
        }
        ImmutableSet paths = pathsBuilder.build();
        if (this.includeComments(request) && (discussion = this.findDiscussionById(request.getRepository(), request.getUntilId())) != null) {
            try {
                callback.offerAnchors(this.commentHelper.findDiffAnchors(discussion, request.getSinceId(), (String)Iterables.getFirst((Iterable)paths, null)));
            }
            catch (IOException exc) {
                log.error("Error while callback.offerAnchors", (Throwable)exc);
            }
        }
        Repository repository = request.getRepository();
        this.getCommandFactory(repository).diff(((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths((Iterable)paths)).sinceId(request.getSinceId()).untilId(request.getUntilId()).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void traverse(@Nonnull TraversalRequest request, @Nonnull TraversalCallback callback) {
        this.graphSource.traverse(request, callback);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public boolean unwatch(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.watcherService.removeCurrentUserAsWatcher((InternalWatchable)this.getDiscussion(repository, commitId, true, false));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment updateComment(@Nonnull Repository repository, @Nonnull String commitId, long commentId, int commentVersion, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.update((InternalCommentable)this.getDiscussionOrNoComment(repository, commitId, false), commentId, commentVersion, commentText);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Watcher watch(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.watcherService.addCurrentUserAsWatcher((InternalWatchable)this.getDiscussion(repository, commitId, true, false));
    }

    private CommitCallback enrichingCallback(CommitCallback callback, final Repository repository, final Collection<String> propertyKeys) {
        return new BatchingCommitCallback(callback, 25){

            protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
                commits = DefaultCommitService.this.enricher.enrichAll(repository, commits, propertyKeys);
                return super.onCommits(commits);
            }
        };
    }

    private Map<InternalChangeLocation, CommentCounts> getCountsByLocation(ChangesRequest request) {
        InternalCommitDiscussion discussion;
        Map countsByLocation = Collections.emptyMap();
        if (this.includeCounts(request) && (discussion = this.findDiscussionById(request.getRepository(), request.getUntilId())) != null) {
            countsByLocation = this.commentHelper.countsByLocation((InternalCommentable)discussion);
        }
        return countsByLocation;
    }

    private InternalCommitDiscussion getDiscussion(@Nonnull Repository repository, @Nonnull String commitId, boolean create, boolean participate) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)commitId, (Object)"commitId");
        return this.discussionSource.get(new CommitDiscussionRequest.Builder(repository, commitId).create(create).participate(participate).build());
    }

    @Nonnull
    private InternalCommitDiscussion getDiscussionOrNoComment(@Nonnull Repository repository, @Nonnull String commitId, boolean participate) {
        InternalCommitDiscussion discussion = this.getDiscussion(repository, commitId, false, participate);
        if (discussion == null) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("bitbucket.service.comment.nosuchcomment", new Object[0]));
        }
        return discussion;
    }

    private boolean includeComments(DiffRequest request) {
        return request.isWithComments() && this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_READ);
    }

    private boolean includeCounts(ChangesRequest request) {
        return request.isWithComments() && this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_READ);
    }

    private Optional<String> resolveSrcPath(DiffRequest request) {
        CommitsBetweenRequest srcPathRequest = new CommitsBetweenRequest.Builder(request.getRepository()).exclude(request.getSinceId(), new String[0]).followRenames(true).include(request.getUntilId(), new String[0]).path((String)Iterables.getOnlyElement((Iterable)request.getPaths())).build();
        return this.getCommitsBetween(srcPathRequest, PageUtils.newRequest((int)0, (int)1)).stream().findFirst().map(PropertySupport::getProperties).map(properties -> {
            Map changeMap;
            Object change = properties.get((Object)"change");
            if (change instanceof Map && (changeMap = (Map)change).get("type") == ChangeType.MOVE) {
                return (String)changeMap.get("srcPath");
            }
            return null;
        });
    }

    private int restrictMessageLength(int length) {
        if (length < 0 || length > this.maxMessageLength) {
            return this.maxMessageLength;
        }
        return length;
    }
}

