/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.CommitPropertyConfiguration;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.user.InternalUserService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=com.atlassian.bitbucket.commit.CommitEnricher.class)
@Component(value="commitEnricher")
@Transactional(readOnly=true)
public class DatabaseCommitEnricher
implements com.atlassian.bitbucket.commit.CommitEnricher {
    private final RepositoryActivityDao activityDao;
    private final AuthenticationContext authenticationContext;
    private final CommitPropertyConfiguration configuration;
    private final CommitIndex index;
    private final InternalUserService userService;

    @Autowired
    public DatabaseCommitEnricher(RepositoryActivityDao activityDao, AuthenticationContext authenticationContext, CommitPropertyConfiguration propertyConfiguration, CommitIndex index, InternalUserService userService) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.configuration = propertyConfiguration;
        this.index = index;
        this.userService = userService;
    }

    @Nonnull
    public Commit enrich(@Nonnull Repository repository, @Nonnull Commit commit, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)commit, (Object)"commit");
        return this.createEnricher(repository, Collections.singleton(commit), propertyKeys).apply(commit);
    }

    @Nonnull
    public Iterable<Commit> enrichAll(@Nonnull Repository repository, @Nonnull Iterable<Commit> commits, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(commits, (Object)"commits");
        return Iterables.transform(commits, this.createEnricher(repository, commits, propertyKeys)::apply);
    }

    @Nonnull
    public Page<Commit> enrichPage(@Nonnull Repository repository, @Nonnull Page<Commit> page, Collection<String> propertyKeys) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(page, (Object)"page");
        return page.transform(this.createEnricher(repository, page.getValues(), propertyKeys));
    }

    private Function<Commit, Commit> createEnricher(Repository repository, Iterable<Commit> commits, Collection<String> propertyKeys) {
        Set<String> commitIds = this.toIds(commits, MinimalCommit::getId);
        Map propertiesByCommit = this.index.getProperties(commitIds, this.getPropertiesToLoad(repository, propertyKeys));
        Map<String, Long> commentsByCommit = this.mapCommentsByCommit(repository.getId(), commitIds);
        Map<String, ApplicationUser> usersByEmail = this.mapUsersByEmail(commits, Commit.TO_AUTHOR);
        if (propertiesByCommit.isEmpty() && usersByEmail.isEmpty() && commentsByCommit.isEmpty()) {
            return Function.identity();
        }
        return new CommitEnricher(propertiesByCommit, commentsByCommit, usersByEmail);
    }

    @Nonnull
    private Set<String> getPropertiesToLoad(Repository repository, Collection<String> propertiesRequested) {
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll((Iterable)this.configuration.getPropertiesToPreload(repository));
        if (propertiesRequested != null) {
            builder.addAll(propertiesRequested);
        }
        return builder.build();
    }

    private Map<String, Long> mapCommentsByCommit(int repositoryId, Set<String> commitIds) {
        if (this.authenticationContext.isAuthenticated()) {
            return this.activityDao.countCommentsByCommit(repositoryId, commitIds);
        }
        return Collections.emptyMap();
    }

    private <T> Map<String, ApplicationUser> mapUsersByEmail(Iterable<T> commits, Function<? super T, Person> toAuthor) {
        Set emailAddresses = Chainable.chain(commits).transform(toAuthor).transform(Person.TO_EMAIL_ADDRESS).filter(StringUtils::isNotBlank).toSet();
        return this.userService.mapUsersByEmail(emailAddresses);
    }

    private <T> Set<String> toIds(Iterable<T> commits, Function<? super T, String> toId) {
        return Chainable.chain(commits).transform(toId).toSet();
    }

    private static class CommitEnricher
    implements Function<Commit, Commit> {
        private final Map<String, PropertyMap> propertiesByCommit;
        private final Map<String, Long> commentsByCommit;
        private final Map<String, ApplicationUser> usersByEmail;

        private CommitEnricher(Map<String, PropertyMap> propertiesByCommit, Map<String, Long> commentsByCommit, Map<String, ApplicationUser> usersByEmail) {
            this.propertiesByCommit = propertiesByCommit;
            this.commentsByCommit = commentsByCommit;
            this.usersByEmail = usersByEmail;
        }

        @Override
        public Commit apply(Commit commit) {
            Long comments;
            PropertyMap properties;
            SimpleCommit.Builder builder = null;
            ApplicationUser user = this.usersByEmail.get(commit.getAuthor().getEmailAddress());
            if (user != null) {
                builder = new SimpleCommit.Builder(commit).author((Person)user);
            }
            if ((properties = this.propertiesByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.properties((Map)properties);
            }
            if ((comments = this.commentsByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.property("commentCount", (Object)comments);
            }
            return builder == null ? commit : builder.build();
        }
    }
}

