/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.cluster.HazelcastClusterInformation;
import com.hazelcast.core.HazelcastInstance;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ClusterService.class)
@Service(value="clusterService")
public class HazelcastClusterService
implements ClusterService {
    private final ClusterInformation clusterInformation;
    private final HazelcastInstance hazelcast;
    private final LicenseService licenseService;

    @Autowired
    public HazelcastClusterService(HazelcastInstance hazelcast, LicenseService licenseService) {
        this.hazelcast = hazelcast;
        this.licenseService = licenseService;
        this.clusterInformation = new HazelcastClusterInformation(hazelcast);
    }

    @Nonnull
    public ClusterInformation getInformation() {
        return this.clusterInformation;
    }

    @Nonnull
    public String getNodeId() {
        return this.clusterInformation.getLocalNode().getId();
    }

    public boolean isAvailable() {
        BitbucketServerLicense license = this.licenseService.get();
        return license != null && license.isClusteringEnabled() && this.hazelcast.getLifecycleService().isRunning();
    }

    public boolean isClustered() {
        return this.isAvailable() && this.hazelcast.getCluster().getMembers().size() > 1;
    }
}

