/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AbstractAvatarSupplier;
import com.atlassian.bitbucket.avatar.AvatarException;
import com.atlassian.bitbucket.avatar.AvatarLoadException;
import com.atlassian.bitbucket.avatar.AvatarResizeException;
import com.atlassian.bitbucket.avatar.AvatarStoreException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.DelegatingCacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.UnsupportedAvatarException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.io.Closeables;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="avatarRepository")
public class DiskAvatarRepository
implements AvatarRepository {
    public static final String AVATARS_PATH = "avatars";
    public static final String AVATAR_FORMAT = "png";
    public static final String FILE_EXTENSION = ".png";
    public static final int MINIMUM_MAX_DIMENSION = 256;
    public static final long MINIMUM_MAX_SIZE = 102400L;
    public static final String ORIGINAL_FILE = "original.png";
    public static final int ORIGINAL_SIZE = -1;
    private static final Logger log = LoggerFactory.getLogger(DiskAvatarRepository.class);
    private final File avatarDir;
    private final I18nService i18nService;
    private final ConcurrentOperationMap<ResizeKey, File> operationMap;
    private final long systemTimestamp;
    private long maxDimension;
    private long maxSize;

    @Autowired
    public DiskAvatarRepository(I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.i18nService = i18nService;
        this.avatarDir = FileUtils.mkdir((File)propertiesService.getDataDir(), (String)AVATARS_PATH);
        this.operationMap = new ConcurrentOperationMapImpl();
        Date timestamp = propertiesService.getBuildTimestamp();
        this.systemTimestamp = timestamp == null ? -1L : timestamp.getTime();
    }

    public void delete(@Nonnull AvatarType type, @Nonnull Object id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        String avatarId = this.parseId(id);
        File instanceDir = FileUtils.construct((File)this.avatarDir, (String[])new String[]{type.getDirectoryName(), avatarId});
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)instanceDir);
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.removalfailed", new Object[]{type.name(), avatarId}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStored(@Nonnull AvatarType type, @Nonnull Object id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        String avatarId = this.parseId(id);
        File original = FileUtils.construct((File)this.avatarDir, (String[])new String[]{type.getDirectoryName(), avatarId, ORIGINAL_FILE});
        try (FileInputStream ignored2222 = new FileInputStream(original);){
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ignored2222) {
            return false;
        }
        catch (IOException e) {
            log.warn("Opening {} avatar {} for ID {} threw an unexpected exception", new Object[]{type, original.getAbsolutePath(), id, e});
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public CacheableAvatarSupplier load(@Nonnull AvatarType type, @Nonnull Object id, int size) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        String avatarId = this.parseId(id);
        size = DiskAvatarRepository.normaliseSize(size);
        File original = FileUtils.construct((File)this.avatarDir, (String[])new String[]{type.getDirectoryName(), avatarId, ORIGINAL_FILE});
        try (FileInputStream originalStream2222 = new FileInputStream(original);){
            File avatar;
            if (size == -1) {
                avatar = original;
            } else {
                ResizeKey key = new ResizeKey(type, avatarId, size);
                try {
                    avatar = (File)this.operationMap.runOperation((Object)key, (Callable)new ResizeAvatarCallable(this.i18nService, original, originalStream2222, size));
                }
                catch (ExecutionException e) {
                    throw (AvatarException)e.getCause();
                }
            }
            LoadedAvatarSupplier loadedAvatarSupplier = new LoadedAvatarSupplier(avatar);
            return loadedAvatarSupplier;
        }
        catch (FileNotFoundException originalStream2222) {
            return this.defaultSupplier(type.loadDefault(avatarId, DiskAvatarRepository.normaliseDefaultSize(size)));
        }
        catch (IOException e) {
            throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.unreadableimage", new Object[0]), (Throwable)e);
        }
    }

    @Nonnull
    public CacheableAvatarSupplier loadDefault(@Nonnull AvatarType type, int size) {
        size = DiskAvatarRepository.normaliseDefaultSize(size);
        return this.defaultSupplier(type.loadFixedDefault(size));
    }

    @Value(value="${avatar.max.dimension}")
    public void setMaxDimension(int maxDimension) {
        if (maxDimension < 256) {
            log.warn("The configured max dimension for avatars, [{}] pixels, is too small and will be ignored. It will be defaulted to {} pixels", (Object)maxDimension, (Object)256);
            maxDimension = 256;
        }
        this.maxDimension = maxDimension;
    }

    @Value(value="${avatar.max.size}")
    public void setMaxSize(long maxSize) {
        if (maxSize < 102400L) {
            log.warn("The configured max file size for avatars, [{}], is too small and will be ignored. It will be defaulted to {}", (Object)NumberUtils.formatSize((double)maxSize), (Object)NumberUtils.formatSize((double)102400.0));
        }
        this.maxSize = maxSize;
    }

    public void store(@Nonnull AvatarType type, @Nonnull Object id, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)supplier, (Object)"supplier");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        String avatarId = this.parseId(id);
        BufferedImage avatar = this.readAvatar(supplier);
        File typeDir = FileUtils.mkdir((File)this.avatarDir, (String)type.getDirectoryName());
        File instanceDir = FileUtils.mkdir((File)typeDir, (String)avatarId);
        if (instanceDir.isDirectory()) {
            try {
                org.apache.commons.io.FileUtils.cleanDirectory((File)instanceDir);
            }
            catch (IOException e) {
                throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.cleanupfailed", new Object[]{type.name()}));
            }
        }
        this.writeAvatar(avatar, new File(instanceDir, ORIGINAL_FILE));
    }

    public long getVersionId(@Nonnull AvatarType type, @Nonnull Object id) {
        CacheableAvatarSupplier supplier = this.load(type, id, -1);
        return supplier.getTimestamp();
    }

    @Nonnull
    private CacheableAvatarSupplier defaultSupplier(@Nonnull AvatarSupplier supplier) {
        return new DelegatingCacheableAvatarSupplier((AvatarSupplier)Preconditions.checkNotNull((Object)supplier, (Object)"supplier"), this.systemTimestamp);
    }

    private String parseId(Object id) {
        String avatarId = String.valueOf(id);
        if (StringUtils.isBlank((CharSequence)avatarId)) {
            throw new IllegalArgumentException("The provided ID produces a String which is blank or null");
        }
        return avatarId;
    }

    private BufferedImage readAvatar(AvatarSupplier supplier) {
        BufferedImage avatar;
        InputStream rawStream;
        try {
            rawStream = supplier.open();
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.supplierfailed", new Object[0]), (Throwable)e);
        }
        if (rawStream == null) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.nostream", new Object[0]));
        }
        ImageReader reader = null;
        try {
            ImageInputStream imageStream = ImageIO.createImageInputStream(rawStream);
            Iterator<ImageReader> readerIterator = ImageIO.getImageReaders(imageStream);
            reader = (ImageReader)Iterators.getNext(readerIterator, null);
            if (reader == null) {
                throw new UnsupportedAvatarException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.unsupportedcontenttype", new Object[0]));
            }
            reader.setInput(imageStream);
            int height = reader.getHeight(0);
            int width = reader.getWidth(0);
            if ((long)height > this.maxDimension || (long)width > this.maxDimension) {
                throw new UnsupportedAvatarException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.unsupporteddimensions", new Object[]{String.valueOf(width), String.valueOf(height), String.valueOf(this.maxDimension)}));
            }
            avatar = reader.read(0);
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.unreadableimage", new Object[0]), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            Closeables.closeQuietly((InputStream)rawStream);
        }
        return avatar;
    }

    private void writeAvatar(BufferedImage avatar, File file) {
        try {
            ImageIO.write((RenderedImage)avatar, AVATAR_FORMAT, file);
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.writefailed", new Object[0]), (Throwable)e);
        }
        long length = file.length();
        if (length > this.maxSize) {
            if (!file.delete()) {
                log.warn("Oversized avatar {} ({}) could not be deleted; will attempt to delete on exit", (Object)file.getAbsolutePath(), (Object)NumberUtils.formatSize((double)length));
                file.deleteOnExit();
            }
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.oversized", new Object[]{NumberUtils.formatSize((double)length), NumberUtils.formatSize((double)this.maxSize)}));
        }
    }

    private static int normaliseDefaultSize(int size) {
        if ((size = DiskAvatarRepository.normaliseSize(size)) == -1) {
            return 256;
        }
        return size;
    }

    private static int normaliseSize(int size) {
        if (size < 0) {
            return -1;
        }
        if (size > 128) {
            return 256;
        }
        if (size > 96) {
            return 128;
        }
        if (size > 64) {
            return 96;
        }
        if (size > 48) {
            return 64;
        }
        return 48;
    }

    private static class ResizeKey {
        private final int[] hashes;

        private ResizeKey(AvatarType type, String id, int size) {
            this.hashes = new int[]{type.ordinal(), id.hashCode(), size};
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ResizeKey) {
                ResizeKey s = (ResizeKey)o;
                return Arrays.equals(this.hashes, s.hashes);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.hashes);
        }
    }

    private static class ResizeAvatarCallable
    implements Callable<File> {
        private final I18nService i18nService;
        private final File original;
        private final InputStream originalStream;
        private final int size;

        private ResizeAvatarCallable(I18nService i18nService, File original, InputStream originalStream, int size) {
            this.i18nService = i18nService;
            this.original = original;
            this.originalStream = originalStream;
            this.size = size;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public File call() throws AvatarException {
            File sized = FileUtils.construct((File)this.original.getParentFile(), (String[])new String[]{this.size + DiskAvatarRepository.FILE_EXTENSION});
            try (FileInputStream ignored2222 = new FileInputStream(sized);){
                File file = sized;
                return file;
            }
            catch (FileNotFoundException ignored2222) {
            }
            catch (IOException e) {
                throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.unreadableimage", new Object[0]), (Throwable)e);
            }
            BufferedImage image = this.readOriginal();
            image = this.resize(image);
            this.writeResized(image, sized);
            return sized;
        }

        private BufferedImage readOriginal() {
            BufferedImage image;
            try {
                image = ImageIO.read(this.originalStream);
            }
            catch (IOException e) {
                throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.unreadableimage", new Object[0]), (Throwable)e);
            }
            return image;
        }

        private BufferedImage render(BufferedImage image, int width, int height, int type, Object hint) {
            BufferedImage tmp = new BufferedImage(width, height, type);
            Graphics2D graphics = tmp.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage(image, 0, 0, width, height, null);
            graphics.dispose();
            return tmp;
        }

        private BufferedImage resize(BufferedImage image) {
            int type;
            int n = type = image.getTransparency() == 1 ? 1 : 2;
            if (this.size > image.getHeight() || this.size > image.getWidth()) {
                image = this.render(image, this.size, this.size, type, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                int height = image.getHeight();
                int width = image.getWidth();
                do {
                    height = this.sizeDown(height);
                    width = this.sizeDown(width);
                    image = this.render(image, width, height, type, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                } while (width != this.size || height != this.size);
            }
            return image;
        }

        private int sizeDown(int dimension) {
            if (dimension > this.size && (dimension /= 2) < this.size) {
                dimension = this.size;
            }
            return dimension;
        }

        private void writeResized(BufferedImage resized, File target) {
            try {
                ImageIO.write((RenderedImage)resized, DiskAvatarRepository.AVATAR_FORMAT, target);
            }
            catch (IOException e) {
                throw new AvatarResizeException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.resizefailed", new Object[0]), (Throwable)e);
            }
        }
    }

    private static class LoadedAvatarSupplier
    extends AbstractAvatarSupplier
    implements CacheableAvatarSupplier {
        private final File avatar;

        private LoadedAvatarSupplier(File avatar) {
            super("image/png");
            this.avatar = avatar;
        }

        @Nonnull
        public InputStream open() throws IOException {
            return new FileInputStream(this.avatar);
        }

        public long getTimestamp() {
            return this.avatar.lastModified();
        }
    }
}

