/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.scm.http.HttpScmRequestHandler;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.util.RequestUtils;
import com.atlassian.stash.internal.scm.http.HttpScmRequestHandlerProvider;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ScmAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    public static final String SCM_SERVLET_PATH = "/scm";
    private final ApplicationModeSupplier modeSupplier;
    private final HttpScmRequestHandlerProvider httpScmRequestHandlerProvider;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;

    public ScmAuthenticationFailureHandler(ApplicationModeSupplier modeSupplier, HttpScmRequestHandlerProvider httpScmRequestHandlerProvider, I18nService i18nService, NavBuilder navBuilder) {
        this.modeSupplier = modeSupplier;
        this.httpScmRequestHandlerProvider = httpScmRequestHandlerProvider;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws IOException {
        String explanation;
        String title;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        AuthenticationState authenticationState = context.getAuthenticationState();
        if (!SCM_SERVLET_PATH.equals(request.getServletPath())) {
            return false;
        }
        Optional optionalHandler = this.httpScmRequestHandlerProvider.getHandler(request);
        if (!optionalHandler.isPresent()) {
            return false;
        }
        HttpScmRequestHandler handler = (HttpScmRequestHandler)optionalHandler.get();
        switch (authenticationState) {
            case CAPTCHA_REQUIRED: {
                title = this.i18nService.getMessage("bitbucket.scm.captcha.required", new Object[0]);
                if (this.modeSupplier.getMode() == ApplicationMode.MIRROR) {
                    explanation = this.i18nService.getMessage("bitbucket.scm.captcha.required.upstream.detail", new Object[]{Product.NAME});
                    break;
                }
                explanation = this.i18nService.getMessage("bitbucket.scm.captcha.required.detail", new Object[]{Product.NAME, this.navBuilder.buildAbsolute()});
                break;
            }
            case UNLICENSED: {
                title = this.i18nService.getMessage("bitbucket.scm.no.licensed.user", new Object[0]);
                explanation = this.i18nService.getMessage("bitbucket.scm.no.licensed.user.detail", new Object[]{Product.NAME});
                break;
            }
            default: {
                title = this.i18nService.getMessage("bitbucket.scm.no.authentication", new Object[0]);
                explanation = this.i18nService.getMessage("bitbucket.scm.no.authentication.detail", new Object[0]);
            }
        }
        response = RequestUtils.unwrap((HttpServletResponse)response);
        handler.sendAuthenticationError(authenticationState, title, explanation, request, response);
        return true;
    }
}

