/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collection;

public final class CommonValidations {
    private static final Predicate<String> NOT_NULL_OR_EMPTY = new Predicate<String>(){

        public boolean apply(String s) {
            return !Strings.isNullOrEmpty((String)s);
        }
    };

    public static void validatePermission(Permission permission) {
        Preconditions.checkNotNull((Object)permission, (Object)"Permission is null");
    }

    public static void validateGrantablePermission(Permission permission) {
        CommonValidations.validatePermission(permission);
        Preconditions.checkArgument((boolean)permission.isGrantable(), (Object)"Permission is not a grantable permission");
    }

    public static void validateGlobalPermission(Permission permission) {
        CommonValidations.validatePermission(permission);
        Preconditions.checkArgument((boolean)permission.isGlobal(), (Object)"Permission is not a global permission");
    }

    public static void validateProjectPermission(Permission permission) {
        CommonValidations.validatePermission(permission);
        Preconditions.checkArgument((boolean)permission.isResource(Project.class), (Object)"Permission is not a project permission");
    }

    public static void validateRepositoryPermission(Permission permission) {
        CommonValidations.validatePermission(permission);
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"Permission is not a repository permission");
    }

    public static void validateResourcePermission(Permission permission) {
        CommonValidations.validatePermission(permission);
        Preconditions.checkArgument((boolean)permission.isResource(), (Object)"Permission is not a resource-based permission");
    }

    public static void validateUser(ApplicationUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"User is null");
    }

    public static void validateUser(String username) {
        Preconditions.checkArgument((boolean)NOT_NULL_OR_EMPTY.apply((Object)username), (Object)"Username is empty");
    }

    public static void validateGroup(String group) {
        Preconditions.checkArgument((boolean)NOT_NULL_OR_EMPTY.apply((Object)group), (Object)"Group is empty");
    }

    public static void validateGroups(Collection<String> groups) {
        Preconditions.checkArgument((groups != null ? 1 : 0) != 0, (Object)"Groups is null");
        Preconditions.checkArgument((boolean)Iterables.all(groups, NOT_NULL_OR_EMPTY), (Object)"Groups has empty groups");
    }

    public static void validateProject(Project project) {
        Preconditions.checkNotNull((Object)project, (Object)"Project is null");
    }

    public static void validateRepository(Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"Repository is null");
    }

    public static void validatePageRequest(PageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"PageRequest is null");
    }
}

