/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.stash.internal.web.HttpRequestInfoHelper;
import java.security.SecureRandom;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="httpRequestInfoHelper")
public class DefaultHttpRequestInfoHelper
implements HttpRequestInfoHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpRequestInfoHelper.class);
    static final String ATTR_SESSION_ID = "bitbucket.session-id";
    private final SecureRandom secureRandom = SecureRandomFactory.newInstance();

    public RequestInfoProvider createRequestInfoProvider(HttpServletRequest request, HttpServletResponse response) {
        return new HttpRequestInfoProvider(request, response);
    }

    public String getRemoteAddress(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        String header = request.getHeader("X-Forwarded-For");
        if (header != null) {
            builder.append(header).append(",");
        }
        builder.append(request.getRemoteAddr());
        return builder.toString().replaceAll("\\s", "");
    }

    public String getRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        if (StringUtils.isNotBlank((CharSequence)request.getContextPath())) {
            url = url.substring(request.getContextPath().length());
        }
        return url;
    }

    public String getSessionId(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String sessionId = null;
        try {
            sessionId = (String)session.getAttribute(ATTR_SESSION_ID);
            if (sessionId == null) {
                byte[] bytes = new byte[40];
                this.secureRandom.nextBytes(bytes);
                CRC32 crc = new CRC32();
                crc.update(bytes);
                sessionId = Long.toString(crc.getValue(), 36);
                session.setAttribute(ATTR_SESSION_ID, (Object)sessionId);
            }
        }
        catch (IllegalStateException e) {
            log.debug("Could not retrieve sessionId: {}", (Object)StringUtils.defaultString((String)e.getMessage()));
        }
        return sessionId;
    }

    private class HttpRequestInfoProvider
    implements RequestInfoProvider {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private String action;
        private String requestDetails;
        private String sessionId;

        private HttpRequestInfoProvider(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        @Nonnull
        public String getAction() {
            if (this.action == null) {
                this.action = "\"" + this.request.getMethod() + " " + DefaultHttpRequestInfoHelper.this.getRequestUrl(this.request) + " " + this.request.getProtocol() + "\"";
            }
            return this.action;
        }

        public String getDetails() {
            if (this.requestDetails == null) {
                this.requestDetails = String.format("\"%1$s\" \"%2$s\"", StringUtils.defaultString((String)StringUtils.substringBefore((String)this.request.getHeader("referer"), (String)"?")), StringUtils.defaultString((String)this.request.getHeader("user-agent")));
            }
            return this.requestDetails;
        }

        @Nonnull
        public String getProtocol() {
            return this.request.getScheme();
        }

        @Nonnull
        public Object getRawRequest() {
            return this.request;
        }

        @Nonnull
        public Object getRawResponse() {
            return this.response;
        }

        public String getRemoteAddress() {
            return DefaultHttpRequestInfoHelper.this.getRemoteAddress(this.request);
        }

        public String getSessionId() {
            if (this.sessionId == null) {
                this.sessionId = DefaultHttpRequestInfoHelper.this.getSessionId(this.request);
            }
            return this.sessionId;
        }

        public boolean hasSessionId() {
            return this.getSessionId() != null;
        }

        public boolean isSecure() {
            return this.request.isSecure();
        }
    }
}

