/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userHelper")
public class DefaultUserHelper
implements UserHelper {
    private final StashUserDao userDao;

    @Autowired
    public DefaultUserHelper(StashUserDao userDao) {
        this.userDao = userDao;
    }

    @Nonnull
    public InternalNormalUser transformOrCreate(@Nonnull User user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        InternalNormalUser loaded = this.userDao.loadUser(user);
        if (loaded == null) {
            loaded = this.newStashUser(user);
        }
        return loaded;
    }

    @Nonnull
    public Page<InternalNormalUser> transformOrCreate(@Nonnull Page<User> page) {
        Preconditions.checkNotNull(page, (Object)"page");
        ImmutableMap stashUsers = Maps.uniqueIndex((Iterable)this.userDao.loadUsers(page.getValues()), Person::getName);
        return page.transform(arg_0 -> this.lambda$transformOrCreate$0((Map)stashUsers, arg_0));
    }

    private InternalNormalUser newStashUser(@Nonnull User user) {
        return this.userDao.createFor(user);
    }

    private /* synthetic */ InternalNormalUser lambda$transformOrCreate$0(Map stashUsers, User user) {
        InternalNormalUser loaded = (InternalNormalUser)stashUsers.get(user.getName());
        if (loaded == null) {
            loaded = this.newStashUser(user);
        }
        return loaded;
    }
}

