/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.task;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestPropertyContext;
import com.atlassian.bitbucket.pull.PullRequestPropertyProvider;
import com.atlassian.bitbucket.task.TaskCount;
import com.atlassian.bitbucket.task.TaskState;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskCountProvider")
public class TaskCountProvider
implements PullRequestPropertyProvider {
    public static final Map<TaskState, String> ATTRIBUTE_KEYS = TaskCountProvider.createAttributeKeys();
    private static final Function<PullRequest, InternalPullRequest> TO_INTERNAL_PULL_REQUEST = InternalConverter::convertToInternalPullRequest;
    private final InternalTaskService taskService;

    @Autowired
    public TaskCountProvider(InternalTaskService taskService) {
        this.taskService = taskService;
    }

    public void provideProperties(@Nonnull PullRequestPropertyContext context) {
        Set internalPullRequests = Chainable.chain((Iterable)context).transform(TO_INTERNAL_PULL_REQUEST).toSet();
        Map counts = this.taskService.countForContexts((Iterable)internalPullRequests);
        for (Map.Entry e : counts.entrySet()) {
            for (TaskState t : TaskState.values()) {
                context.setProperty((PullRequest)e.getKey(), ATTRIBUTE_KEYS.get(t), (Object)((TaskCount)e.getValue()).getCount(t));
            }
        }
    }

    private static Map<TaskState, String> createAttributeKeys() {
        ImmutableMap.Builder attributeKeys = ImmutableMap.builder();
        for (TaskState state : TaskState.values()) {
            attributeKeys.put((Object)state, (Object)(state.name().toLowerCase() + "TaskCount"));
        }
        return attributeKeys.build();
    }
}

