/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.content.SimpleDiff;
import com.atlassian.bitbucket.content.SimpleDiffHunk;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DiffComment {
    private final InternalPullRequestCommentActivity activity;
    private final InternalDiffCommentAnchor anchor;
    private final InternalComment comment;
    private final PropertyMap properties;

    public DiffComment(@Nonnull InternalPullRequestCommentActivity activity, @Nonnull PropertyMap properties) {
        this.activity = (InternalPullRequestCommentActivity)Preconditions.checkNotNull((Object)activity, (Object)"An activity is required");
        this.properties = (PropertyMap)Preconditions.checkNotNull((Object)properties, (Object)"properties");
        this.anchor = (InternalDiffCommentAnchor)Preconditions.checkNotNull((Object)activity.getCommentAnchor(), (Object)"Only anchored comments support gathering context");
        this.comment = activity.getComment();
    }

    public void applyDiff(@Nonnull SimpleDiffHunk hunk) {
        SimpleDiff.Builder diffBuilder = (SimpleDiff.Builder)new SimpleDiff.Builder().destination(this.anchor.getPath()).hunk((DiffHunk)hunk).properties((Map)this.properties);
        if (StringUtils.isNotBlank((CharSequence)this.anchor.getSrcPath())) {
            diffBuilder.source(this.anchor.getSrcPath());
        }
        this.activity.setDiff((Diff)diffBuilder.build());
    }

    public long getId() {
        return this.comment.getId();
    }

    public boolean isDiffApplied() {
        return this.activity.getDiff() != null;
    }

    public boolean isAnchoredOn(@Nonnull DiffContextLine line) {
        return line.isAnchor(this.anchor);
    }
}

