/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;

public class CompositeCommentPostProcessor
implements CommentPostProcessor {
    private final List<CommentPostProcessor> postProcessors;

    public CompositeCommentPostProcessor(List<CommentPostProcessor> postProcessors) {
        this.postProcessors = ImmutableList.copyOf(postProcessors);
    }

    @Override
    @Profiled
    public InternalComment process(InternalCommentable entity, InternalComment comment) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Timer ignored = TimerUtils.start((String)String.format("%s.process comment ID=%d", postProcessor.getClass().getName(), comment.getId()));
            Throwable throwable = null;
            try {
                comment = postProcessor.process(entity, comment);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return comment;
    }

    @Override
    @Profiled
    public Set<InternalComment> processAll(InternalCommentable entity, Set<InternalComment> comments) {
        for (CommentPostProcessor postProcessor : this.postProcessors) {
            Timer ignored = TimerUtils.start((String)String.format("%s.processAll %d comments", postProcessor.getClass().getName(), comments.size()));
            Throwable throwable = null;
            try {
                comments = postProcessor.processAll(entity, comments);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return comments;
    }
}

