/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVeto;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeVeto;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SimpleMergeRequest
implements InternalMergeRequest {
    private final Map<String, Object> context;
    private final boolean dryRun;
    private final String message;
    private final PullRequest pullRequest;
    private final List<PullRequestMergeVeto> vetoes;

    private SimpleMergeRequest(Builder builder) {
        this.context = builder.context.build();
        this.dryRun = builder.dryRun;
        this.message = builder.message;
        this.pullRequest = builder.pullRequest;
        this.vetoes = Lists.newArrayList();
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public Collection<PullRequestMergeVeto> getVetoes() {
        return ImmutableList.copyOf(this.vetoes);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isVetoed() {
        return !this.vetoes.isEmpty();
    }

    public void veto(@Nonnull String summary, @Nonnull String detailedMessage) {
        this.vetoes.add(new SimplePullRequestMergeVeto(summary, detailedMessage));
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> context;
        private final PullRequest pullRequest;
        private boolean dryRun;
        private String message;

        public Builder(PullRequest pullRequest) {
            this.pullRequest = (PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            this.context = ImmutableMap.builder();
            this.dryRun = true;
        }

        public Builder(@Nonnull PullRequest pullRequest, @Nonnull PullRequestMergeRequest mergeRequest) {
            this(pullRequest);
            this.message = ((PullRequestMergeRequest)Preconditions.checkNotNull((Object)mergeRequest, (Object)"mergeRequest")).getMessage();
            this.dryRun = false;
            this.context.putAll(mergeRequest.getContext());
        }

        @Nonnull
        public SimpleMergeRequest build() {
            return new SimpleMergeRequest(this);
        }

        @Nonnull
        public Builder context(@Nonnull String key, @Nonnull String value) {
            this.context.put((Object)key, (Object)value);
            return this;
        }

        @Nonnull
        public Builder context(@Nonnull Map<String, Object> value) {
            this.context.putAll(value);
            return this;
        }

        @Nonnull
        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        @Nonnull
        public Builder message(@Nonnull String value) {
            this.message = value;
            return this;
        }
    }
}

