/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.restore;

import com.atlassian.stash.internal.maintenance.CompositeMaintenanceTask;
import com.atlassian.stash.internal.maintenance.restore.RestoreState;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestorePhase
extends CompositeMaintenanceTask {
    private static final Logger log = LoggerFactory.getLogger(RestorePhase.class);
    private final RestoreState state;

    protected RestorePhase(RestoreState state, CompositeMaintenanceTask.Step[] steps, int totalWeight) {
        super(steps, totalWeight);
        this.state = state;
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            File unpackedDirectory = this.state.getUnzippedBackupDirectory();
            if (unpackedDirectory != null && unpackedDirectory.exists()) {
                if (FileUtils.deleteQuietly((File)unpackedDirectory)) {
                    log.debug("Successfully deleted unpacked files from {}", (Object)unpackedDirectory.getAbsolutePath());
                } else {
                    log.warn("Failed to delete unpacked files at {}; the directory has been marked for deletion on exit", (Object)unpackedDirectory.getAbsolutePath());
                    unpackedDirectory.deleteOnExit();
                }
            }
        }
    }

    public static class Builder
    extends CompositeMaintenanceTask.AbstractBuilder<Builder> {
        private final RestoreState state;

        public Builder(RestoreState state) {
            this.state = state;
        }

        @Override
        @Nonnull
        public RestorePhase build() {
            return new RestorePhase(this.state, this.steps.toArray(new CompositeMaintenanceTask.Step[this.steps.size()]), this.totalWeight);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

