/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.hazelcast.NodeIdMemberSelector;
import com.atlassian.stash.internal.maintenance.IncorrectTokenMaintenanceException;
import com.atlassian.stash.internal.maintenance.InternalMaintenanceService;
import com.atlassian.stash.internal.maintenance.LockFailedMaintenanceException;
import com.atlassian.stash.internal.maintenance.MaintenanceLock;
import com.atlassian.stash.internal.maintenance.latch.ResultCollectingExecutionCallback;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.spring.context.SpringAware;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@SpringAware
public class ClusterMaintenanceLock
implements MaintenanceLock,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ClusterMaintenanceLock.class);
    private transient IExecutorService executorService;
    private transient I18nService i18nService;
    private transient InternalMaintenanceService maintenanceService;
    private final ApplicationUser owner;
    private final String token;

    public ClusterMaintenanceLock(@Nonnull ApplicationUser owner, @Nonnull String token, IExecutorService executorService, I18nService i18nService, InternalMaintenanceService maintenanceService) {
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.maintenanceService = maintenanceService;
        this.owner = (ApplicationUser)Preconditions.checkNotNull((Object)owner, (Object)"owner");
        this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
    }

    public void lock() {
        FailureTrackingCallback callback = new FailureTrackingCallback();
        try {
            this.executorService.submitToAllMembers((Runnable)new LockTask(this), (MultiExecutionCallback)callback);
            callback.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!callback.isSuccess()) {
                    this.unlock(this.token);
                    String failedNodeIds = StringUtils.join(callback.getFailedNodes(), (String)", ");
                    throw new LockFailedMaintenanceException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.lock.failed", new Object[]{failedNodeIds}));
                }
                throw throwable;
            }
        }
        if (!callback.isSuccess()) {
            this.unlock(this.token);
            String failedNodeIds = StringUtils.join(callback.getFailedNodes(), (String)", ");
            throw new LockFailedMaintenanceException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.lock.failed", new Object[]{failedNodeIds}));
        }
    }

    @Nonnull
    public ApplicationUser getOwner() {
        return this.owner;
    }

    @Nonnull
    public String getUnlockToken() {
        return this.token;
    }

    @Autowired
    public void setExecutorService(IExecutorService executorService) {
        this.executorService = executorService;
    }

    @Autowired
    public void setI18nService(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    @Autowired
    public void setMaintenanceService(InternalMaintenanceService maintenanceService) {
        this.maintenanceService = maintenanceService;
    }

    public void unlock(@Nonnull String token) {
        if (((String)Preconditions.checkNotNull((Object)token, (Object)"token")).equals(this.token)) {
            FailureTrackingCallback callback = new FailureTrackingCallback();
            this.executorService.submitToAllMembers((Callable)new UnlockTask(token), (MultiExecutionCallback)callback);
            try {
                if (!callback.await(1L, TimeUnit.MINUTES)) {
                    log.info("Timed out waiting for all nodes to unlock");
                }
                if (!callback.isSuccess()) {
                    log.info("Failed to unlock some nodes: {}. Retrying", (Object)StringUtils.join(callback.getFailedNodes(), (String)", "));
                    this.executorService.submitToMembers((Callable)new UnlockTask(token), (MemberSelector)new NodeIdMemberSelector(callback.getFailedNodes()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("Interrupted while waiting for nodes to unlock");
            }
        } else {
            log.warn("An invalid token ({}) was supplied to attempt to unlock the system", (Object)token);
            throw new IncorrectTokenMaintenanceException(this.i18nService.createKeyedMessage("bitbucket.service.maintenance.lock.incorrectunlocktoken", new Object[0]), token);
        }
        this.maintenanceService.clearClusterLock();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMaintenanceLock that = (ClusterMaintenanceLock)o;
        return this.token.equals(that.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    @SpringAware
    private static class UnlockTask
    implements Callable<Void>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient InternalMaintenanceService maintenanceService;
        private final String unlockToken;

        private UnlockTask(String unlockToken) {
            this.unlockToken = unlockToken;
        }

        @Override
        public Void call() {
            MaintenanceLock lock = this.maintenanceService.getNodeLock();
            if (lock != null) {
                lock.unlock(this.unlockToken);
            }
            return null;
        }

        @Autowired
        public void setMaintenanceService(InternalMaintenanceService maintenanceService) {
            this.maintenanceService = maintenanceService;
        }
    }

    @SpringAware
    private static class LockTask
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final MaintenanceLock lockInfo;
        private transient InternalMaintenanceService maintenanceService;

        private LockTask(MaintenanceLock lockInfo) {
            this.lockInfo = lockInfo;
        }

        @Override
        public void run() {
            this.maintenanceService.lockNode(this.lockInfo);
        }

        @Autowired
        public void setMaintenanceService(InternalMaintenanceService maintenanceService) {
            this.maintenanceService = maintenanceService;
        }
    }

    private static class FailureTrackingCallback
    extends ResultCollectingExecutionCallback<Void> {
        private final Set<String> failedNodes = Sets.newHashSet();

        private FailureTrackingCallback() {
        }

        public Set<String> getFailedNodes() {
            return this.failedNodes;
        }

        @Override
        protected void onError(Member member, Throwable throwable) {
            this.failedNodes.add(member.getUuid());
        }
    }
}

