/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.hook.HookResponse;
import com.atlassian.bitbucket.hook.PreReceiveHook;
import com.atlassian.bitbucket.hook.repository.PreReceiveRepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookContext;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.RepositoryHookSettingsCallback;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreReceiveRepositoryHookAdapter
implements PreReceiveHook {
    private static final Logger log = LoggerFactory.getLogger(PreReceiveRepositoryHookAdapter.class);
    private final InternalRepositoryHookService hookService;

    public PreReceiveRepositoryHookAdapter(InternalRepositoryHookService hookService) {
        this.hookService = hookService;
    }

    public boolean onReceive(final @Nonnull Repository repository, final @Nonnull Collection<RefChange> refChanges, final @Nonnull HookResponse hookResponse) {
        return this.hookService.visitEnabledHooks(repository, PreReceiveRepositoryHook.class, (RepositoryHookSettingsCallback)new RepositoryHookSettingsCallback<PreReceiveRepositoryHook>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean visit(@Nonnull String key, @Nonnull PreReceiveRepositoryHook hook, @Nonnull Settings settings) {
                try (Timer timer = TimerUtils.start((String)(hook.getClass().getName() + "#onReceive"));){
                    if (hook.onReceive(new RepositoryHookContext(repository, settings), refChanges, hookResponse)) return true;
                    boolean bl = false;
                    return bl;
                }
                catch (RuntimeException e) {
                    hookResponse.err().println("Hook " + hook.getClass().getName() + " failed. Error: ");
                    hookResponse.err().println(e.getMessage());
                    log.warn("Receive Hook {} failed.", (Object)hook.getClass().getName(), (Object)e);
                    return false;
                }
            }
        });
    }
}

