/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.ConfigurationAmendment;
import com.atlassian.stash.internal.config.ConfigurationLineProcessor;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.DataSourceConfigurationAmendment;
import com.atlassian.stash.internal.config.FileOperationException;
import com.atlassian.stash.internal.config.RemovePropertiesAmendment;
import com.atlassian.stash.internal.config.RemoveSetupConfigurationRequest;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.internal.util.FilePermissionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

@Service(value="configurationService")
public class DefaultConfigurationService
implements ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationService.class);
    private final AuthenticationContext authenticationContext;
    private final Clock clock;
    private final File sharedHomeDir;
    private final I18nService i18nService;
    private final TransactionSynchronizer synchronizer;

    @Autowired
    public DefaultConfigurationService(@Value(value="#{applicationSettings.sharedHomeDir}") File sharedHomeDir, AuthenticationContext authenticationContext, Clock clock, I18nService i18nService, TransactionSynchronizer synchronizer) {
        this.authenticationContext = (AuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sharedHomeDir = (File)Preconditions.checkNotNull((Object)sharedHomeDir);
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService);
        this.synchronizer = synchronizer;
    }

    @Nonnull
    public DataSourceConfiguration loadDataSourceConfiguration() throws IOException {
        Properties properties = this.loadCurrentConfig();
        return new SimpleDataSourceConfiguration(properties.getProperty("jdbc.driver"), properties.getProperty("jdbc.url"), properties.getProperty("jdbc.user"), properties.getProperty("jdbc.password"));
    }

    public void saveDataSourceConfiguration(@Nonnull DataSourceConfiguration dataSourceConfig) {
        this.saveDataSourceConfiguration(dataSourceConfig, (Option<String>)Option.none());
    }

    public void saveDataSourceConfiguration(@Nonnull DataSourceConfiguration dataSourceConfig, @Nonnull Option<String> message) {
        Preconditions.checkNotNull((Object)dataSourceConfig);
        Preconditions.checkNotNull(message);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        DataSourceConfigurationAmendment amendment = new DataSourceConfigurationAmendment(dataSourceConfig, message, this.clock, currentUser);
        try {
            this.applyAmendment(amendment);
            File configFile = this.getConfigFile();
            try {
                FilePermissionUtils.setRestrictedFilePermissions(configFile);
            }
            catch (IOException e) {
                log.warn("Could not restrict file permissions on config file " + configFile.getAbsolutePath(), (Throwable)e);
            }
        }
        catch (IOException e) {
            throw this.newFileOperationException("bitbucket.configuration.setup.datasourcefailed", e);
        }
    }

    public void removeSetupProperties(@Nonnull RemoveSetupConfigurationRequest request) {
        Preconditions.checkNotNull((Object)request);
        RemovePropertiesAmendment amendment = new RemovePropertiesAmendment(this.clock, request.toProperties());
        try {
            this.applyAmendment(amendment);
        }
        catch (IOException e) {
            throw this.newFileOperationException("bitbucket.configuration.setup.removefailed", e);
        }
    }

    @VisibleForTesting
    void applyAmendment(ConfigurationAmendment amendment) throws IOException {
        File original = this.getConfigFile();
        File draft = this.createDraftConfigFile();
        File backup = null;
        try {
            try (BufferedWriter draftWriter = this.openFile(draft);){
                if (original.exists()) {
                    backup = this.getBackUpConfigFile(original);
                    ConfigurationLineProcessor lineProcessor = new ConfigurationLineProcessor(draftWriter, amendment);
                    Files.readLines((File)original, (Charset)Charsets.UTF_8, (LineProcessor)lineProcessor);
                }
                amendment.finalize(draftWriter);
            }
            this.swapConfigFile(original, draft, backup);
        }
        catch (FileOperationException | IOException e) {
            this.deleteFile(draft);
            if (backup != null) {
                this.deleteFile(backup);
            }
            throw e;
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            log.warn("Failed to delete {}. Setting it to delete upon exit", (Object)file.getAbsolutePath());
            file.deleteOnExit();
        }
    }

    private FileOperationException newFileOperationException(String i18nKey, IOException ioe) {
        String configurationFilePath = this.getConfigFile().getAbsolutePath();
        return new FileOperationException(this.i18nService.createKeyedMessage(i18nKey, new Object[]{configurationFilePath}), ioe);
    }

    private void swapConfigFile(final File original, File draft, final File backup) {
        this.rename(draft, original);
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (status == 1 || status == 2) {
                    log.warn("Transaction was rolled back or is in an unknown state. Restoring original {} file (if available)", (Object)"bitbucket.properties");
                    if (backup != null) {
                        DefaultConfigurationService.this.rename(backup, original);
                    }
                }
            }
        });
    }

    private void rename(File src, File dst) {
        try {
            Files.move((File)src, (File)dst);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.draft.rename", new Object[]{src, dst});
            throw new FileOperationException(message, e);
        }
    }

    @VisibleForTesting
    File getBackUpConfigFile(File original) {
        File backupFile = new File(original.getAbsolutePath() + ".bak");
        try {
            Files.copy((File)original, (File)backupFile);
            return backupFile;
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.configCopyFail", new Object[]{original, backupFile, Product.NAME});
            throw new FileOperationException(message, e);
        }
    }

    private File getConfigFile() {
        return new File(this.sharedHomeDir, "bitbucket.properties");
    }

    private File createDraftConfigFile() {
        try {
            return File.createTempFile("draft", "properties", this.sharedHomeDir);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.tempFile.create", new Object[0]);
            throw new FileOperationException(message, e);
        }
    }

    private Properties loadCurrentConfig() {
        Resource[] configResources = new Resource[]{new ClassPathResource("application-internal.properties"), new ClassPathResource("application-default.properties"), new FileSystemResource(this.getConfigFile())};
        Properties properties = new Properties();
        for (Resource resource : configResources) {
            try {
                PropertiesLoaderUtils.fillProperties((Properties)properties, (Resource)resource);
            }
            catch (IOException e) {
                log.warn("Problem loading properties from {}", (Object)resource.getFilename(), (Object)e);
            }
        }
        return properties;
    }

    private BufferedWriter openFile(File file) {
        try {
            return Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.tempFile.notFound", new Object[]{file});
            throw new FileOperationException(message, e);
        }
    }
}

