/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

class TaskBucket<T>
implements DataSerializable {
    private LinkedHashSet<T> scheduled = new LinkedHashSet();
    private boolean executing;

    TaskBucket() {
    }

    boolean add(T task) {
        return this.scheduled.add(task);
    }

    boolean isEmpty() {
        return this.scheduled.isEmpty();
    }

    boolean isExecuting() {
        return this.executing;
    }

    public void readData(ObjectDataInput objectDataInput) throws IOException {
        this.scheduled = new LinkedHashSet();
        int items = objectDataInput.readInt();
        for (int i = 0; i < items; ++i) {
            this.scheduled.add(objectDataInput.readObject());
        }
        this.executing = objectDataInput.readBoolean();
    }

    void returnAll(Collection<T> tasks) {
        LinkedHashSet<T> combined = new LinkedHashSet<T>(tasks);
        combined.addAll(this.scheduled);
        this.scheduled = combined;
    }

    void setExecuting(boolean executing) {
        this.executing = executing;
    }

    List<T> take(int max) {
        if (max <= 0 || this.scheduled.isEmpty()) {
            return Collections.emptyList();
        }
        if (max >= this.scheduled.size()) {
            ArrayList<T> result = new ArrayList<T>(this.scheduled);
            this.scheduled = new LinkedHashSet();
            return result;
        }
        ArrayList result = new ArrayList(max);
        Iterator it = this.scheduled.iterator();
        for (int i = 0; i < max; ++i) {
            result.add(it.next());
            it.remove();
        }
        return result;
    }

    public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
        objectDataOutput.writeInt(this.scheduled.size());
        for (Object task : this.scheduled) {
            objectDataOutput.writeObject(task);
        }
        objectDataOutput.writeBoolean(this.executing);
    }
}

