/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.concurrent.ClusterMappedLock;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import javax.annotation.Nonnull;

public class HazelcastPullRequestLock
implements PullRequestLock {
    private static final String LOCK_PREFIX = "lock.stash.pull-request.";
    private final ClusterMappedLock lock;

    public HazelcastPullRequestLock(HazelcastInstance hazelcast, String lockName) {
        this.lock = new ClusterMappedLock(hazelcast, LOCK_PREFIX + lockName);
    }

    public <T, E extends Exception> T withLock(int repositoryId, long pullRequestId, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(repositoryId + "/" + pullRequestId, operation);
    }

    public <T, E extends Exception> T withLock(@Nonnull PullRequest pullRequest, @Nonnull Operation<T, E> operation) throws E {
        return this.withLock(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository().getId(), pullRequest.getId(), operation);
    }
}

