/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.CommentChain;
import com.atlassian.bitbucket.comment.CommentPropertyContext;
import com.atlassian.bitbucket.comment.CommentPropertyProvider;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.InternalConverter;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component(value="commentRepositoryProvider")
public class CommentRepositoryPropertyProvider
implements CommentPropertyProvider {
    public void provideProperties(@Nonnull CommentPropertyContext context) {
        Repository repository = (Repository)context.accept((CommentableVisitor)new CommentableVisitor<Repository>(){

            public Repository visit(@Nonnull CommitDiscussion commitDiscussion) {
                return commitDiscussion.getRepository();
            }

            public Repository visit(@Nonnull PullRequest pullRequest) {
                return InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getScopeRepository();
            }
        });
        new CommentChain((Iterable)context).stream().filter(comment -> !comment.getProperties().containsKey((Object)"repositoryId")).forEach(comment -> context.setProperty(comment, "repositoryId", (Object)repository.getId()));
    }
}

