/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.event.user.UserAvatarUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionRequest;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.DataUriAvatarMetaSupplier;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.user.CaptchaTicket;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.PasswordResetHelper;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.internal.user.UserHelper;
import com.atlassian.stash.internal.util.InternalPageUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserService.class)
@Service(value="userService")
public class DefaultUserService
extends AbstractService
implements InternalUserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private final InternalAvatarService avatarService;
    private final InternalAuthenticationContext authenticationContext;
    private final CaptchaService captchaService;
    private final CrowdControl crowdControl;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PasswordResetHelper passwordResetHelper;
    private final PermissionService permissionService;
    private final StashUserDao userDao;
    private final UserHelper userHelper;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;
    @Value(value="${page.max.groups}")
    private int maxGroupPageSize;

    @Autowired
    public DefaultUserService(@Lazy InternalAvatarService avatarService, InternalAuthenticationContext authenticationContext, @Lazy CaptchaService captchaService, CrowdControl crowdControl, EventPublisher eventPublisher, I18nService i18nService, PasswordResetHelper passwordResetHelper, @Lazy PermissionService permissionService, StashUserDao userDao, UserHelper userHelper) {
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.captchaService = captchaService;
        this.crowdControl = crowdControl;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.passwordResetHelper = passwordResetHelper;
        this.permissionService = permissionService;
        this.userDao = userDao;
        this.userHelper = userHelper;
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS, noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public ApplicationUser authenticate(@Nonnull String username, @Nonnull String password) {
        log.debug("Authenticating user: {}", (Object)username);
        User crowdUser = this.crowdControl.authenticate(username, password);
        return this.getOrCreateMappedUser(crowdUser);
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS, noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public ApplicationUser authenticateWithCaptcha(@Nonnull String username, @Nonnull String password) {
        CaptchaTicket ticket = this.captchaService.checkCaptcha(username, null);
        return this.captchaService.authenticateWithCaptcha(ticket, () -> this.authenticate(username, password));
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void deleteAvatar(@Nonnull ApplicationUser user) {
        this.avatarService.deleteForUser((ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user"));
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public boolean existsGroup(String groupName) {
        return this.crowdControl.findGroup(groupName) != null;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<String> findGroups(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroups(pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<String> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByName(groupName, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<String> findGroupsByPrefix(String groupPrefix, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxGroupPageSize);
        return this.crowdControl.findGroupsByPrefix(groupPrefix, pageRequest);
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<String> findGroupsByUser(@Nonnull String username, @Nonnull PageRequest pageRequest) {
        return this.crowdControl.findGroupsByUser(username, null, false, pageRequest).transform(arg_0 -> ((Function)IdentifierUtils.TO_LOWER_CASE).apply(arg_0));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ServiceUser> findServiceUsersByName(String displayName, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ServiceUser.class, (Page)this.userDao.findServiceUsersByName(displayName, pageRequest));
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts; it is used for password resets")
    public ApplicationUser findUserByNameOrEmail(@Nonnull String value) {
        User user;
        if (((String)Preconditions.checkNotNull((Object)value, (Object)"value")).contains("@") && (user = this.crowdControl.findUserByProperty(UserTermKeys.EMAIL, (Object)value)) != null) {
            return this.getOrCreateMappedUser(user);
        }
        return this.userDao.findByName(value);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ApplicationUser> findUsers(@Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(this.crowdControl.findUsers(pageRequest)));
    }

    @Nonnull
    @Unsecured(value="Used in unauthenticated contexts by licensing, permission checks and login processing")
    public Page<ApplicationUser> findUsersByGroup(@Nonnull String groupName, @Nonnull PageRequest pageRequest) {
        return this.findUsersByGroup(groupName, null, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Page<ApplicationUser> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(this.crowdControl.findUsersByName(username, pageRequest)));
    }

    @Nonnull
    @Unsecured(value="User avatars are not more privileged than getUserBySlug(String)")
    public CacheableAvatarSupplier getAvatar(@Nonnull ApplicationUser user, int size) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return this.avatarService.getForUser(user, size);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getServiceUserByName(@Nonnull String username) {
        return this.getServiceUserByName(username, false);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getServiceUserByName(@Nonnull String username, boolean inactive) {
        return this.userDao.findServiceUserByName((String)Preconditions.checkNotNull((Object)username, (Object)"username"), inactive);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ServiceUser getServiceUserBySlug(@Nonnull String slug) {
        return this.userDao.findServiceUserBySlug((String)Preconditions.checkNotNull((Object)slug, (Object)"slug"));
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserById(int id) {
        return this.getUserById(id, false);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserById(int id, boolean inactive) {
        return this.maybeFilterInactive((InternalApplicationUser)this.userDao.getById((Object)id), inactive);
    }

    public ApplicationUser getUserByKey(UserKey key) {
        return this.getUserByKey(key, false);
    }

    public ApplicationUser getUserByKey(UserKey key, boolean inactive) {
        if (key == null) {
            return null;
        }
        try {
            return this.getUserById(Integer.parseInt(key.getStringValue()), inactive);
        }
        catch (NumberFormatException e) {
            return this.getUserByName(key.getStringValue(), inactive);
        }
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserByName(@Nonnull String username) {
        return this.getUserByName(username, false);
    }

    @Transactional
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserByName(@Nonnull String username, boolean inactive) {
        if (this.authenticationContext.isAuthenticated() && IdentifierUtils.equalsInLowerCase((String)username, (String)this.authenticationContext.getCurrentUser().getName())) {
            return this.authenticationContext.getCurrentToken().getPrincipal();
        }
        return this.maybeFilterInactive(this.userDao.findByName((String)Preconditions.checkNotNull((Object)username, (Object)"username")), inactive);
    }

    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public ApplicationUser getUserBySlug(@Nonnull String slug) {
        Preconditions.checkNotNull((Object)slug, (Object)"slug");
        if (this.authenticationContext.isAuthenticated() && this.authenticationContext.getCurrentUser().getSlug().equals(slug)) {
            return this.authenticationContext.getCurrentToken().getPrincipal();
        }
        return this.maybeFilterInactive(this.userDao.findBySlug(slug), false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public Set<ApplicationUser> getUsersById(@Nonnull Set<Integer> ids) {
        return this.getUsersById(ids, false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available in unauthenticated contexts")
    public Set<ApplicationUser> getUsersById(@Nonnull Set<Integer> ids, boolean inactive) {
        List users = this.userDao.getByIds(ids);
        if (!inactive) {
            users = users.stream().filter(ApplicationUser::isActive).collect(Collectors.toList());
        }
        return ImmutableSet.copyOf((Collection)users);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<ApplicationUser> getUsersByName(@Nonnull Set<String> usernames) {
        return this.getUsersByName(usernames, false);
    }

    @Nonnull
    @Unsecured(value="Should be on the same level of permission as getUserByName(String)")
    public Set<ApplicationUser> getUsersByName(@Nonnull Set<String> usernames, boolean inactive) {
        Set users = this.userDao.findByNames(usernames);
        if (!inactive) {
            users = users.stream().filter(ApplicationUser::isActive).collect(Collectors.toSet());
        }
        return ImmutableSet.copyOf((Collection)users);
    }

    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public boolean isUserInGroup(@Nonnull ApplicationUser user, final @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)groupName);
        InternalApplicationUser internalUser = InternalConverter.convertToInternalUser((ApplicationUser)user);
        return (Boolean)internalUser.accept((InternalStashUserVisitor)new InternalStashUserVisitor<Boolean>(){

            public Boolean visit(@Nonnull InternalNormalUser user) {
                User crowdUser = user.getBackingCrowdUser();
                if (crowdUser == null && (crowdUser = DefaultUserService.this.crowdControl.findUser(user.getUsername(), true)) == null) {
                    return false;
                }
                return DefaultUserService.this.crowdControl.isGroupMember(groupName, crowdUser);
            }

            public Boolean visit(@Nonnull InternalServiceUser user) {
                return false;
            }
        });
    }

    @Unsecured(value="This is not restricted by permissions so that SAL tests pass. It should not be exposed via REST")
    public boolean isUserInGroup(@Nonnull String username, @Nonnull String groupName) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)groupName);
        ApplicationUser user = this.getUserByName(username);
        return user != null && this.isUserInGroup(user, groupName);
    }

    @Nonnull
    @Transactional
    @Unsecured(value="This should not be more private than findUserByNameOrEmail")
    public Map<String, ApplicationUser> mapUsersByEmail(@Nonnull Set<String> emailAddresses) {
        HashMap usersByEmail = Maps.newHashMapWithExpectedSize((int)emailAddresses.size());
        for (String emailAddress : emailAddresses) {
            ApplicationUser user = this.findUserByNameOrEmail(emailAddress);
            if (user == null) continue;
            usersByEmail.put(emailAddress, user);
        }
        return usersByEmail;
    }

    @Transactional
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public ApplicationUser preauthenticate(@Nonnull String username) {
        log.debug("Authenticating user: {}", (Object)username);
        ApplicationUser user = this.getUserByName(username);
        if (user == null) {
            user = this.getServiceUserByName(username);
        }
        if (user != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)StashUserAuthenticationToken.forUser((ApplicationUser)user));
        }
        return user;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public Page<ApplicationUser> search(@Nonnull UserSearchRequest request, @Nonnull PageRequest pageRequest) {
        String username = request.getFilter();
        String groupName = request.getGroup();
        Set permissions = request.getPermissions();
        if (permissions.isEmpty()) {
            return PageUtils.asPageOf(ApplicationUser.class, this.findUsersByGroup(groupName, username, pageRequest));
        }
        this.validatePermissions(permissions);
        Predicate<ApplicationUser> predicates = user -> true;
        for (PermissionRequest permissionRequest : permissions) {
            predicates = predicates.and(user -> this.hasPermission(permissionRequest, (ApplicationUser)user));
        }
        PageProvider userProvider = r -> PageUtils.asPageOf(ApplicationUser.class, this.findUsersByGroup(groupName, username, r));
        return InternalPageUtils.filterPages(userProvider, predicates, pageRequest, this.maxUserPageSize * 2);
    }

    @Unsecured(value="This needs to be available to all contexts")
    public void unauthenticate() {
        SecurityContextHolder.clearContext();
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void updateAvatar(@Nonnull ApplicationUser user, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkNotNull((Object)supplier, (Object)"supplier");
        this.doUpdateAvatar(user, (Supplier<AvatarSupplier>)Suppliers.ofInstance((Object)supplier));
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void updateAvatar(@Nonnull ApplicationUser user, @Nonnull String uri) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)uri, (Object)"uri")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank data URI is required");
        this.doUpdateAvatar(user, new DataUriAvatarMetaSupplier(this.avatarService, uri));
    }

    @Transactional
    @Unsecured(value="Internal service method")
    public void updateLastAuthentication(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, false);
        if (user != null) {
            this.crowdControl.setUserAttribute(user, "lastAuthenticationTimestamp", (Object)System.currentTimeMillis());
        }
    }

    @Transactional
    @PreAuthorize(value="isAuthenticated()")
    public void updatePassword(@Nonnull String currentPassword, @Nonnull String newPassword) {
        String name = this.getCurrentUserForUpdate().getName();
        try {
            User user = this.crowdControl.authenticate(name, currentPassword);
            this.passwordResetHelper.resetPassword(user, newPassword);
        }
        catch (IncorrectPasswordAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.service.user.password.invalid", new Object[0]));
        }
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public ApplicationUser updateUser(@Nonnull String displayName, @Nonnull String email) {
        Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        Preconditions.checkNotNull((Object)email, (Object)"email");
        String name = this.getCurrentUserForUpdate().getName();
        User user = this.crowdControl.updateUser(ImmutableUser.newUser().name(name).displayName(displayName).emailAddress(email).toUser());
        return this.userHelper.transformOrCreate(user);
    }

    private void doUpdateAvatar(@Nonnull ApplicationUser user, @Nonnull Supplier<AvatarSupplier> metaSupplier) {
        this.avatarService.saveForUser((ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user"), (AvatarSupplier)((Supplier)Preconditions.checkNotNull(metaSupplier, (Object)"metaSupplier")).get());
        this.eventPublisher.publish((Object)new UserAvatarUpdatedEvent((Object)this, user));
    }

    private Page<ApplicationUser> findUsersByGroup(String groupName, String username, PageRequest pageRequest) {
        if (groupName == null) {
            return this.findUsersByName(username, pageRequest);
        }
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        return PageUtils.asPageOf(ApplicationUser.class, (Page)this.userHelper.transformOrCreate(this.crowdControl.findUsersByGroup(groupName, username, false, pageRequest)));
    }

    @Nonnull
    private ApplicationUser getCurrentUserForUpdate() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.user.anonymousupdate", new Object[0]));
        }
        return user;
    }

    private InternalNormalUser getOrCreateMappedUser(User crowdUser) {
        return this.userHelper.transformOrCreate(crowdUser);
    }

    private boolean hasPermission(PermissionRequest permissionRequest, ApplicationUser user) {
        Permission permission = permissionRequest.getPermission();
        Object resource = permissionRequest.getResource();
        if (permission.isGlobal()) {
            return this.permissionService.hasGlobalPermission(user, permission);
        }
        if (permission.isResource(Project.class)) {
            if (resource instanceof Project) {
                return this.permissionService.hasProjectPermission(user, (Project)permissionRequest.getResourceAs(Project.class), permission);
            }
            if (resource instanceof Integer) {
                return this.permissionService.hasProjectPermission(user, ((Integer)permissionRequest.getResourceAs(Integer.class)).intValue(), permission);
            }
        }
        if (permission.isResource(Repository.class)) {
            if (resource instanceof Repository) {
                return this.permissionService.hasRepositoryPermission(user, (Repository)permissionRequest.getResourceAs(Repository.class), permission);
            }
            if (resource instanceof Integer) {
                return this.permissionService.hasRepositoryPermission(user, ((Integer)permissionRequest.getResourceAs(Integer.class)).intValue(), permission);
            }
        }
        throw new AssertionError((Object)("Unsupported resource type " + resource.getClass().getName()));
    }

    private <U extends InternalApplicationUser> U maybeFilterInactive(U user, boolean inactive) {
        return (U)(inactive || user != null && user.isActive() ? user : null);
    }

    private void validatePermissions(Set<PermissionRequest> requests) {
        for (PermissionRequest request : requests) {
            this.validatePermissionRequest(request);
        }
    }

    private void validatePermissionRequest(PermissionRequest request) {
        Permission permission = request.getPermission();
        Object resource = request.getResource();
        if (permission.isGlobal()) {
            if (resource != null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.permission.globalresource", new Object[]{request.getResource()}));
            }
        } else {
            if (resource == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.permission.emptyresource", new Object[]{request.getPermission()}));
            }
            if (!permission.isResource(resource.getClass())) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.user.permission.incompatibleresource", new Object[]{resource.getClass().getName(), permission, permission.getResourceTypes().stream().map(Class::getName).collect(Collectors.toSet())}));
            }
        }
    }
}

