/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.user.CompositePermissionGraph;
import com.atlassian.stash.internal.user.DefaultPermissionGraph;
import com.atlassian.stash.internal.user.PermissionGraph;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

class DefaultEscalatedSecurityContext
implements EscalatedSecurityContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultEscalatedSecurityContext.class);
    private final DefaultPermissionGraph elevatedPermissions;
    private final boolean impersonateUser;
    private final String reason;
    private final RequestManager requestManager;
    private final ApplicationUser user;

    private DefaultEscalatedSecurityContext(Builder builder) {
        this.elevatedPermissions = builder.permissionsBuilder.build();
        this.impersonateUser = builder.impersonateUser;
        this.reason = builder.reason;
        this.requestManager = builder.requestManager;
        this.user = builder.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T call(@Nonnull Operation<T, E> operation) throws E {
        Preconditions.checkNotNull(operation, (Object)"operation cannot be null");
        Authentication authToken = SecurityContextHolder.getContext().getAuthentication();
        StashUserAuthenticationToken runAsToken = this.createRunAsToken();
        SecurityContextHolder.getContext().setAuthentication((Authentication)runAsToken);
        try {
            log.trace("doWithPermission: running as {}", (Object)runAsToken);
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(authToken);
        }
    }

    public void applyToRequest() {
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext == null || !requestContext.isActive()) {
            throw new IllegalStateException("No request is active");
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.createRunAsToken());
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Permission permission) {
        return new Builder(this).withPermission((Permission)Preconditions.checkNotNull((Object)permission, (Object)"permission")).build();
    }

    @Nonnull
    public EscalatedSecurityContext withPermission(@Nonnull Object resource, @Nonnull Permission permission) {
        return new Builder(this).withPermission(resource, permission).build();
    }

    @Nonnull
    public EscalatedSecurityContext withPermissions(@Nonnull Set<Permission> permissions) {
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder().addGraph(this.elevatedPermissions);
        int index = 0;
        for (Permission permission : permissions) {
            builder.add((Permission)Preconditions.checkNotNull((Object)permission, (String)"permissions[%s]", (Object[])new Object[]{index++}), null);
        }
        return new Builder(this).withPermissions(permissions).build();
    }

    private StashUserAuthenticationToken createRunAsToken() {
        Authentication currentToken = SecurityContextHolder.getContext().getAuthentication();
        PermissionGraph currentElevatedPermissions = null;
        ApplicationUser currentUser = null;
        if (currentToken instanceof StashUserAuthenticationToken) {
            StashUserAuthenticationToken stashToken = (StashUserAuthenticationToken)currentToken;
            currentElevatedPermissions = stashToken.getElevatedPermissions();
            currentUser = stashToken.getPrincipal();
        }
        return new StashUserAuthenticationToken.Builder().user(this.impersonateUser ? this.user : currentUser).elevatedPermissions(CompositePermissionGraph.maybeCompose(currentElevatedPermissions, (PermissionGraph)this.elevatedPermissions)).build();
    }

    static class Builder {
        private final RequestManager requestManager;
        private final String reason;
        private DefaultPermissionGraph.Builder permissionsBuilder;
        private boolean impersonateUser;
        private ApplicationUser user;

        Builder(@Nonnull String reason, @Nonnull RequestManager requestManager) {
            this.requestManager = (RequestManager)Preconditions.checkNotNull((Object)requestManager, (Object)"requestManager");
            this.reason = (String)Preconditions.checkNotNull((Object)reason, (Object)"reason");
            this.permissionsBuilder = new DefaultPermissionGraph.Builder();
        }

        Builder(@Nonnull DefaultEscalatedSecurityContext escalatedSecurityContext) {
            Preconditions.checkNotNull((Object)escalatedSecurityContext, (Object)"escalatedSecurityContext");
            this.impersonateUser = escalatedSecurityContext.impersonateUser;
            this.permissionsBuilder = new DefaultPermissionGraph.Builder().addGraph(escalatedSecurityContext.elevatedPermissions);
            this.reason = escalatedSecurityContext.reason;
            this.requestManager = escalatedSecurityContext.requestManager;
            this.user = escalatedSecurityContext.user;
        }

        @Nonnull
        Builder anonymously() {
            this.impersonateUser = true;
            this.user = null;
            return this;
        }

        @Nonnull
        DefaultEscalatedSecurityContext build() {
            return new DefaultEscalatedSecurityContext(this);
        }

        @Nonnull
        Builder impersonating(@Nonnull ApplicationUser user) {
            this.impersonateUser = true;
            this.user = (ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user");
            return this;
        }

        @Nonnull
        Builder withPermission(@Nonnull Permission permission) {
            this.permissionsBuilder.add((Permission)Preconditions.checkNotNull((Object)permission, (Object)"permission"), null);
            return this;
        }

        @Nonnull
        Builder withPermission(@Nonnull Object resource, @Nonnull Permission permission) {
            Integer resourceId;
            if (Preconditions.checkNotNull((Object)resource, (Object)"resource") instanceof Repository) {
                resourceId = ((Repository)resource).getId();
                Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"Repository permission required");
            } else if (resource instanceof Project) {
                resourceId = ((Project)resource).getId();
                Preconditions.checkArgument((boolean)permission.isResource(Project.class), (Object)"Project permission required");
            } else {
                throw new IllegalArgumentException("Only repository and project resources are supported. Got " + resource.getClass().getCanonicalName());
            }
            this.permissionsBuilder.add(permission, resourceId);
            return this;
        }

        @Nonnull
        Builder withPermissions(@Nonnull Iterable<Permission> permissions) {
            int index = 0;
            for (Permission permission : (Iterable)Preconditions.checkNotNull(permissions, (Object)"permissions")) {
                this.permissionsBuilder.add((Permission)Preconditions.checkNotNull((Object)permission, (String)"permissions[%s]", (Object[])new Object[]{index++}), null);
            }
            return this;
        }
    }
}

