/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task.enrich;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.content.AbstractProviderContext;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.InternalTaskContextVisitor;
import com.atlassian.stash.internal.task.enrich.TaskEnricher;
import com.atlassian.stash.internal.task.property.TaskPropertyContext;
import com.atlassian.stash.internal.task.property.TaskPropertyProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class PropertyTaskEnricher
implements TaskEnricher {
    private final List<TaskPropertyProvider> propertyProviders;

    public PropertyTaskEnricher(List<TaskPropertyProvider> propertyProviders) {
        this.propertyProviders = ImmutableList.copyOf(propertyProviders);
    }

    @Override
    @Nonnull
    public InternalTask enrich(@Nonnull InternalTask task) {
        if (task.hasProperties()) {
            return task;
        }
        Context context = new Context(task.getContext(), task);
        for (TaskPropertyProvider provider : this.getPropertyProviders()) {
            provider.provideProperties(context);
        }
        return new Enricher(context).apply(task);
    }

    @Override
    @Nonnull
    public Iterable<InternalTask> enrich(@Nonnull InternalTaskContext taskContext, @Nonnull Iterable<InternalTask> tasks) {
        Set toProcess = Chainable.chain(tasks).filter(task -> !task.hasProperties()).toSet();
        Context context = new Context(taskContext, toProcess);
        for (TaskPropertyProvider provider : this.getPropertyProviders()) {
            provider.provideProperties(context);
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(tasks, (Function)new Enricher(context)));
    }

    private List<TaskPropertyProvider> getPropertyProviders() {
        return this.propertyProviders;
    }

    private static class Enricher
    implements Function<InternalTask, InternalTask> {
        private final Context context;

        public Enricher(Context context) {
            this.context = context;
        }

        public InternalTask apply(InternalTask task) {
            if (!task.hasProperties()) {
                task.setProperties(this.context.getPropertiesFor(task));
            }
            return task;
        }
    }

    private static class Context
    extends AbstractProviderContext<InternalTask>
    implements TaskPropertyContext {
        private final InternalTaskContext taskContext;

        private Context(InternalTaskContext taskContext, InternalTask task) {
            this(taskContext, (Set<InternalTask>)ImmutableSet.of((Object)task));
        }

        private Context(InternalTaskContext taskContext, Set<InternalTask> tasks) {
            super(tasks);
            this.taskContext = taskContext;
        }

        @Override
        public <T> T accept(InternalTaskContextVisitor<T> visitor) {
            if (this.taskContext instanceof InternalPullRequest) {
                return (T)visitor.visit((InternalPullRequest)this.taskContext);
            }
            throw new UnsupportedOperationException("Cannot visit " + this.taskContext.getClass());
        }
    }
}

