/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=FeatureManager.class)
@Component(value="featureManager")
public class PropertyFeatureManager
implements FeatureManager {
    static final String PROP_PREFIX = "feature.";
    private final Properties applicationProperties;
    private final ConcurrentMap<String, Boolean> features;
    private LicenseService licenseService;

    @Autowired
    public PropertyFeatureManager(@Qualifier(value="applicationProperties") Properties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.features = PropertyFeatureManager.loadFeatures(applicationProperties);
    }

    public boolean isAvailable(@Nonnull Feature feature) {
        Objects.requireNonNull(feature, "feature");
        if (!feature.isDataCenter()) {
            return true;
        }
        BitbucketServerLicense license = this.licenseService.get();
        return license != null && license.isClusteringEnabled();
    }

    public boolean isEnabled(@Nonnull Feature feature) {
        return this.isEnabled(feature, false);
    }

    public boolean isEnabled(@Nonnull Feature feature, boolean defaultValue) {
        Objects.requireNonNull(feature, "feature");
        if (!this.isAvailable(feature)) {
            return false;
        }
        Boolean enabled = (Boolean)this.features.get(feature.getKey());
        if (enabled == null) {
            String enabledString = this.applicationProperties.getProperty(PROP_PREFIX + feature.getKey());
            if (enabledString != null) {
                this.features.putIfAbsent(feature.getKey(), Boolean.parseBoolean(enabledString));
                enabled = (Boolean)this.features.get(feature.getKey());
            } else {
                enabled = defaultValue;
            }
        }
        return enabled;
    }

    @Autowired
    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    private static ConcurrentMap<String, Boolean> loadFeatures(Properties properties) {
        ConcurrentMap features = Maps.newConcurrentMap();
        for (StandardFeature feature : StandardFeature.values()) {
            features.put(feature.getKey(), Boolean.parseBoolean(properties.getProperty(PROP_PREFIX + feature.getKey())));
        }
        return features;
    }
}

