/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.stash.internal.sal.user.DelegatingUserSettings;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MapUserSettingsBuilder
implements UserSettingsBuilder {
    private static final String KEY_TOO_LONG_MESSAGE_FORMAT = "Key {%s} is too long. Keys must be up to [%d] characters long";
    private static final String VALUE_TOO_LONG_MESSAGE_FORMAT = "Value {%s} is too long. Values must be up to [%d] characters long";
    private final Map<String, Object> settingsMap = Maps.newHashMap();

    @Nonnull
    public MapUserSettingsBuilder put(@Nonnull String key, @Nonnull String value) {
        this.settingsMap.put(this.validateKey(key), this.validateValue(value));
        return this;
    }

    @Nonnull
    public MapUserSettingsBuilder put(@Nonnull String key, boolean value) {
        this.settingsMap.put(this.validateKey(key), value);
        return this;
    }

    @Nonnull
    public MapUserSettingsBuilder put(@Nonnull String key, long value) {
        this.settingsMap.put(this.validateKey(key), value);
        return this;
    }

    @Nonnull
    public MapUserSettingsBuilder remove(@Nonnull String key) {
        this.settingsMap.remove(key);
        return this;
    }

    @Nonnull
    public Option<Object> get(@Nonnull String key) {
        return Option.option((Object)this.settingsMap.get(key));
    }

    @Nonnull
    public Set<String> getKeys() {
        return this.settingsMap.keySet();
    }

    @Nonnull
    public MapUserSettingsBuilder putAll(@Nonnull DelegatingUserSettings userSettings) {
        return this.putAll(userSettings.getSettings());
    }

    @Nonnull
    public MapUserSettingsBuilder putAll(@Nonnull Settings settings) {
        this.settingsMap.putAll(settings.asMap());
        return this;
    }

    @Nonnull
    public DelegatingUserSettings build() {
        return new DelegatingUserSettings(new MapSettingsBuilder().addAll(this.settingsMap).build());
    }

    private String validateKey(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        Preconditions.checkArgument((key.length() <= UserSettingsService.MAX_KEY_LENGTH ? 1 : 0) != 0, (Object)String.format(KEY_TOO_LONG_MESSAGE_FORMAT, key, UserSettingsService.MAX_KEY_LENGTH));
        return key;
    }

    private String validateValue(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value cannot be null");
        Preconditions.checkArgument((value.length() <= 255 ? 1 : 0) != 0, (Object)String.format(VALUE_TOO_LONG_MESSAGE_FORMAT, value, UserSettingsService.MAX_KEY_LENGTH));
        return value;
    }
}

