/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.experimental.request.ExperimentalRequestContext;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class DefaultRequestContext
implements ExperimentalRequestContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestContext.class);
    private final AuthenticationContext authenticationContext;
    private final List<Runnable> cleanupCallbacks;
    private final RequestInfoProvider delegate;
    private final String id;
    private final SortedSet<String> labels;
    private volatile boolean active;
    private volatile ApplicationUser authenticatedUser;
    private volatile long bytesRead;
    private volatile long bytesWritten;
    private volatile Duration duration;

    DefaultRequestContext(AuthenticationContext authenticationContext, RequestInfoProvider delegate, String id) {
        this.authenticationContext = authenticationContext;
        this.delegate = delegate;
        this.id = id;
        this.active = true;
        this.cleanupCallbacks = new ArrayList<Runnable>();
        this.labels = new TreeSet<String>();
    }

    public void addCleanupCallback(@Nonnull Runnable callback) {
        this.cleanupCallbacks.add(callback);
    }

    public void addLabel(@Nonnull String label) {
        this.labels.add(label);
        MDC.put((String)"a-request-labels", (String)StringUtils.join(this.labels, (String)", ").replace("|", "\\|"));
    }

    @Nonnull
    public String getAction() {
        return this.delegate.getAction();
    }

    @Nonnull
    public Optional<ApplicationUser> getAuthenticatedUser() {
        return Optional.ofNullable(this.authenticatedUser);
    }

    @Nonnull
    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public String getDetails() {
        return this.delegate.getDetails();
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    @Nonnull
    public Object getRawRequest() {
        return this.delegate.getRawRequest();
    }

    @Nonnull
    public Object getRawResponse() {
        return this.delegate.getRawResponse();
    }

    public String getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    public String getSessionId() {
        return this.delegate.getSessionId();
    }

    public boolean hasSessionId() {
        return this.delegate.hasSessionId();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setAuthenticatedUser(@Nonnull ApplicationUser user) {
        this.authenticatedUser = Objects.requireNonNull(user, "user");
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long bytesRead) {
        MDC.put((String)"a-request-bytes-read", (String)Long.toString(bytesRead));
        this.bytesRead = bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long bytesWritten) {
        MDC.put((String)"a-response-bytes-written", (String)Long.toString(bytesWritten));
        this.bytesWritten = bytesWritten;
    }

    @Nonnull
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    public void setDuration(@Nonnull Duration duration) {
        this.duration = Objects.requireNonNull(duration, "duration");
    }

    public void setResponseCode(int responseCode) {
        MDC.put((String)"a-status-code", (String)Integer.toString(responseCode));
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public void runCleanupCallbacks() {
        for (Runnable callback : this.cleanupCallbacks) {
            try {
                callback.run();
            }
            catch (Exception e) {
                log.warn("Request cleanup callback failed", (Throwable)e);
            }
        }
        this.active = false;
    }
}

