/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.BackupProgressMonitor;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.maintenance.AbstractMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.AoBackupProgressMonitor;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.google.common.base.Preconditions;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.io.output.CloseShieldOutputStream;

public class ActiveObjectsBackupStep
extends AbstractMaintenanceTask {
    private final I18nService i18nService;
    private final Backup backup;
    private final AoBackupProgressMonitor monitor;
    private final BackupState state;

    public ActiveObjectsBackupStep(BackupState state, I18nService i18nService, OsgiServiceProxyFactory proxyFactory) {
        this.backup = (Backup)proxyFactory.createProxy(Backup.class, TimeUnit.SECONDS.toMillis(5L));
        this.state = state;
        this.i18nService = i18nService;
        this.monitor = new AoBackupProgressMonitor(i18nService);
    }

    @Nonnull
    public Progress getProgress() {
        return this.monitor.getProgress();
    }

    public void run() {
        ZipOutputStream stream = this.state.getBackupZipStream();
        Preconditions.checkState((stream != null ? 1 : 0) != 0, (Object)"A backup ZipOutputStream is required");
        try {
            ZipEntry entry = new ZipEntry("active-objects-data.xml");
            stream.putNextEntry(entry);
            this.backup.save((OutputStream)new CloseShieldOutputStream((OutputStream)stream), (BackupProgressMonitor)this.monitor);
            stream.closeEntry();
        }
        catch (Exception e) {
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.activeobjects.failed", new Object[0]), (Throwable)e);
        }
    }
}

