/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.NoSuchResourceException;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.AbstractRefCallback;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"moveSnapshotDirUpgradeTask"})
@Service(value="repositorySnapshotService")
public class FileSystemRepositorySnapshotService
implements RepositorySnapshotService {
    public static final String SNAPSHOTS_PATH = "snapshots";
    public static final long TIMEOUT_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final long TIMEOUT_MINIMUM = TimeUnit.MINUTES.toMillis(1L);
    private static Function<Long, String> TIMESTAMP_TO_STRING = new Function<Long, String>(){

        public String apply(Long input) {
            return Long.toString(input);
        }
    };
    private final I18nService i18nService;
    private final ScmService scmService;
    private final File snapshotDir;
    private long executionTimeout;
    private long idleTimeout;

    @Autowired
    public FileSystemRepositorySnapshotService(ApplicationSettings settings, I18nService i18nService, ScmService scmService) {
        this.scmService = scmService;
        this.i18nService = i18nService;
        this.snapshotDir = com.atlassian.bitbucket.util.FileUtils.mkdir((File)settings.getDataDir(), (String)SNAPSHOTS_PATH);
        this.executionTimeout = TIMEOUT_DEFAULT;
        this.idleTimeout = TIMEOUT_DEFAULT;
    }

    @Override
    public Iterable<String> create(@Nonnull Repository repository, @Nonnull Long timestamp) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        File snapshotFile = this.getSnapshotFile(repository, timestamp);
        try {
            final ArrayList heads = new ArrayList(1000);
            ScmCommandFactory commandFactory = this.scmService.getCommandFactory(repository);
            Command command = commandFactory.heads((RefCallback)new AbstractRefCallback(){

                public boolean onRef(@Nonnull Ref ref) throws IOException {
                    heads.add(ref.getLatestCommit());
                    return true;
                }
            });
            command.setExecutionTimeout(this.executionTimeout);
            command.setIdleTimeout(this.idleTimeout);
            command.call();
            Files.write(snapshotFile.toPath(), heads, StandardCharsets.UTF_8, new OpenOption[0]);
            return ImmutableSet.copyOf(heads);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write snapshot file [" + snapshotFile.getAbsolutePath() + "]", e);
        }
    }

    @Override
    public void deleteByRepository(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        try {
            FileUtils.deleteDirectory((File)this.getRepositorySnapshotDir(repository));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting the snapshot files for repository " + repository.getName(), e);
        }
    }

    @Override
    @Nonnull
    public Iterable<String> getByRepository(@Nonnull Repository repository, Long timestamp) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        if (timestamp == null) {
            return Collections.emptySet();
        }
        File snapshotFile = this.getSnapshotFile(repository, timestamp);
        try {
            return Files.readAllLines(snapshotFile.toPath(), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new NoSuchResourceException(this.i18nService.createKeyedMessage("bitbucket.service.repositorysnapshot.snapshotfilenotfound", new Object[0]), snapshotFile.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read snapshot file [" + snapshotFile.getAbsolutePath() + "]", e);
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.deleteByRepository(event.getRepository());
    }

    @Override
    public void pruneByRepository(@Nonnull Repository repository, @Nonnull Set<Long> timestampsToKeep) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(timestampsToKeep, (Object)"timestampsToKeep");
        ImmutableSet snapshotFilesToKeep = ImmutableSet.copyOf((Iterable)Iterables.transform(timestampsToKeep, TIMESTAMP_TO_STRING));
        File snapshotDir = this.getRepositorySnapshotDir(repository);
        File[] files = snapshotDir.listFiles();
        if (files != null && files.length > 0) {
            for (File snapshotFile : files) {
                if (snapshotFilesToKeep.contains(snapshotFile.getName()) || snapshotFile.delete()) continue;
                snapshotFile.deleteOnExit();
            }
        }
    }

    @Value(value="${indexing.snapshot.timeout.execution}")
    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = Math.max(TimeUnit.SECONDS.toMillis(executionTimeout), TIMEOUT_MINIMUM);
    }

    @Value(value="${indexing.snapshot.timeout.idle}")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = Math.max(TimeUnit.SECONDS.toMillis(idleTimeout), TIMEOUT_MINIMUM);
    }

    private File getRepositorySnapshotDir(Repository repository) {
        return com.atlassian.bitbucket.util.FileUtils.mkdir((File)this.snapshotDir, (String)String.valueOf(repository.getId()));
    }

    private File getSnapshotFile(Repository repository, long timestamp) {
        File repositorySnapshotDir = this.getRepositorySnapshotDir(repository);
        return new File(repositorySnapshotDir, String.valueOf(timestamp));
    }
}

