/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.idx.HierarchyIndexer;
import com.atlassian.stash.internal.idx.HierarchyIndexingRequest;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CommitIndexingScheduler {
    private static final Logger log = LoggerFactory.getLogger(CommitIndexingScheduler.class);
    private final BucketedExecutor<HierarchyIndexingRequest> executor;
    private final ApplicationMode mode;

    @Autowired
    public CommitIndexingScheduler(ConcurrencyService concurrencyService, HierarchyIndexer hierarchyIndexer, @Value(value="#{applicationPropertiesService.mode}") ApplicationMode mode, @Value(value="${indexing.max.threads}") int maxConcurrency) {
        this.mode = mode;
        this.executor = concurrencyService.getBucketedExecutor("commit-indexing", new BucketedExecutorSettings.Builder(HierarchyIndexingRequest.BUCKET_EXTRACTOR, (BucketProcessor)hierarchyIndexer).maxConcurrency(maxConcurrency, ConcurrencyPolicy.PER_NODE).build());
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        if (this.mode == ApplicationMode.MIRROR) {
            return;
        }
        Repository repository = event.getRepository();
        if (event.getRefChanges().isEmpty()) {
            log.debug("{}: Skipping indexing; no refs were changed (Remotely-merged pull request?)", (Object)repository);
        } else {
            this.executor.submit((Serializable)new HierarchyIndexingRequest(repository));
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdown();
    }
}

