/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n.cache;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class MessageKey {
    public static final Function<? super MessageKey, ? extends String> TO_KEY = MessageKey::getKey;
    private final String key;
    private final Locale locale;

    public MessageKey(@Nonnull String key, @Nonnull Locale locale) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.locale = (Locale)Preconditions.checkNotNull((Object)locale, (Object)"locale");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageKey that = (MessageKey)o;
        return this.key.equals(that.key) && this.locale.equals(that.locale);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + this.locale.hashCode();
    }

    public String toString() {
        return String.format("[key=%s;locale=%s]", this.key, this.locale);
    }
}

