/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.atlassian.stash.internal.i18n.cache.MessageKey;
import com.atlassian.stash.internal.i18n.cache.MessageMap;
import com.atlassian.stash.internal.i18n.cache.UnresolvedLocales;
import com.atlassian.stash.internal.plugin.PluginPathScanner;
import com.atlassian.stash.internal.plugin.PluginPathScannerFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(I18nClasspathScanner.class);
    private final PluginPathScannerFactory pluginPathScannerFactory;

    public I18nClasspathScanner(PluginPathScannerFactory pluginPathScannerFactory) {
        this.pluginPathScannerFactory = pluginPathScannerFactory;
    }

    public UnresolvedLocales<String> scanForMessages(Plugin plugin, Locale defaultLocale) {
        List<String> i18nResources = I18nClasspathScanner.getI18nResources(plugin);
        if (i18nResources.isEmpty()) {
            log.trace("Skipping adding plugin {} - no i18n resources", (Object)plugin.getName());
            return new UnresolvedLocales<String>();
        }
        log.trace("Adding plugin {} with {}", (Object)plugin.getName(), i18nResources);
        return I18nClasspathScanner.loadPropertiesLazy(plugin, defaultLocale, I18nClasspathScanner.scanForI18nResources(this.pluginPathScannerFactory.forPlugin(plugin), i18nResources));
    }

    @VisibleForTesting
    static UnresolvedLocales<String> loadPropertiesLazy(final Plugin plugin, final Locale defaultLocale, Iterable<Pair<String, Option<Locale>>> files) {
        ImmutableListMultimap perLocale = Multimaps.index(files, (Function)new Function<Pair<String, Option<Locale>>, Locale>(){

            public Locale apply(Pair<String, Option<Locale>> pair) {
                return (Locale)((Option)pair.right()).getOrElse((Object)defaultLocale);
            }
        });
        log.trace("For plugin {} found the following {}", (Object)plugin, files);
        UnresolvedLocales.Builder<String> unresolved = new UnresolvedLocales.Builder<String>();
        for (final Map.Entry localeFiles : perLocale.asMap().entrySet()) {
            unresolved.put((Locale)localeFiles.getKey(), new Supplier<MessageMap<String>>(){

                public MessageMap<String> get() {
                    try {
                        return I18nClasspathScanner.loadProperties(plugin, (Locale)localeFiles.getKey(), (Iterable)Chainable.chain((Iterable)((Iterable)localeFiles.getValue())).transform(Pair::left));
                    }
                    catch (IOException e) {
                        log.error("Error loading locale from plugin {}", (Object)plugin, (Object)e);
                        return MessageMap.empty();
                    }
                }
            });
        }
        return unresolved.build();
    }

    private static MessageMap<String> loadProperties(Plugin plugin, Locale locale, Iterable<String> files) throws IOException {
        MessageMap.Builder<String> b = new MessageMap.Builder<String>();
        for (String pair : files) {
            Properties properties = new Properties();
            String path = pair.startsWith("/") ? pair.substring(1) : pair;
            try (InputStream in = plugin.getResourceAsStream(path);){
                properties.load(in);
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                b.put(new MessageKey(e.getKey().toString(), locale), e.getValue().toString());
            }
        }
        return b.build();
    }

    @VisibleForTesting
    static Iterable<Pair<String, Option<Locale>>> scanForI18nResources(PluginPathScanner pluginPathScanner, Collection<String> i18nResources) {
        ImmutableListMultimap dirsAndPaths = Multimaps.index(i18nResources, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path.contains(".") ? path.substring(0, path.lastIndexOf(46)).replace('.', '/') + "/" : "";
            }
        });
        ArrayList i18nFiles = Lists.newArrayList();
        for (Map.Entry dirEntry : dirsAndPaths.asMap().entrySet()) {
            block1: for (String file : pluginPathScanner.getPaths("/" + (String)dirEntry.getKey())) {
                for (String classpath : (Collection)dirEntry.getValue()) {
                    Option<Locale> locale = I18nClasspathScanner.getLocale(classpath.replace('.', '/'), file.substring(1));
                    if (locale == null) continue;
                    i18nFiles.add(Pair.pair((Object)file, locale));
                    continue block1;
                }
            }
        }
        return i18nFiles;
    }

    private static List<String> getI18nResources(Plugin plugin) {
        return Chainable.chain((Iterable)plugin.getResourceDescriptors()).filter(arg_0 -> ((Resources.TypeFilter)new Resources.TypeFilter("i18n")).apply(arg_0)).transform(input -> input.getLocation()).toList();
    }

    private static Option<Locale> getLocale(String resource, String path) {
        if (path.startsWith(resource)) {
            char separator = path.charAt(resource.length());
            if (separator == '.') {
                return Option.none();
            }
            if (separator == '_') {
                String locale = path.substring(resource.length() + 1, path.lastIndexOf(46));
                try {
                    return Option.some((Object)LocaleUtils.toLocale((String)locale));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Error in locale for {} file", (Object)path, (Object)e);
                }
            }
        }
        return null;
    }
}

