/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.event.Event;
import com.atlassian.stash.internal.cluster.NodePassivationException;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class HazelcastFactoryBean
extends AbstractFactoryBean<HazelcastInstance> {
    private Config config;
    private ServletContext servletContext;

    public Class<?> getObjectType() {
        return HazelcastInstance.class;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setOutOfMemoryHandler(OutOfMemoryHandler outOfMemoryHandler) {
        Hazelcast.setOutOfMemoryHandler((OutOfMemoryHandler)outOfMemoryHandler);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected HazelcastInstance createInstance() {
        HazelcastInstance hazelcast = Hazelcast.newHazelcastInstance((Config)this.config);
        this.checkNotPassivated(hazelcast);
        return hazelcast;
    }

    private void checkNotPassivated(HazelcastInstance hazelcast) {
        for (Event event : Johnson.getEventContainer((ServletContext)this.servletContext).getEvents()) {
            if (!"node-passivated".equals(event.getKey().getType())) continue;
            hazelcast.shutdown();
            throw new NodePassivationException();
        }
    }
}

