/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content.comment;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.AbstractAddCommentRequest;
import com.atlassian.bitbucket.comment.AddDiffCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.comment.AbstractCommentHelper;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.DiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.commit.CommitDiscussionCommentAnchorDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentActivity;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentAnchor;
import com.atlassian.stash.internal.content.comment.InternalCommitDiscussionCommentHelper;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="commitDiscussionCommentHelper")
public class DefaultCommitDiscussionCommentHelper
extends AbstractCommentHelper<InternalCommitDiscussion, InternalCommitDiscussionCommentAnchor>
implements InternalCommitDiscussionCommentHelper {
    private final RepositoryActivityDao activityDao;

    @Autowired
    public DefaultCommitDiscussionCommentHelper(RepositoryActivityDao activityDao, CommitDiscussionCommentAnchorDao anchorDao, AuthenticationContext authenticationContext, CommentDao commentDao, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, CommentPostProcessor postProcessor, InternalTaskService taskService, Validator validator) {
        super(anchorDao, authenticationContext, commentDao, eventPublisher, i18nService, permissionService, postProcessor, taskService, validator);
        this.activityDao = activityDao;
    }

    @Override
    @Nonnull
    public InternalComment createDiffComment(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddDiffCommentRequest request) {
        return super.createDiffComment(discussion, this.validateToHash(discussion, request));
    }

    @Override
    @Nonnull
    public InternalComment createFileComment(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddFileCommentRequest request) {
        return super.createFileComment(discussion, this.validateToHash(discussion, request));
    }

    @Override
    @Nonnull
    public List<DiffCommentAnchor> findDiffAnchors(@Nonnull InternalCommitDiscussion discussion, @Nullable String parentId, @Nullable String path) {
        return this.search(discussion, new DiffCommentAnchorSearchCriteria.Builder().fromHash(StringUtils.defaultString((String)parentId, (String)discussion.getParentId())).path(path).toHash(discussion.getCommitId()).build());
    }

    @Override
    @Nullable
    public InternalCommitDiscussionCommentAnchor getAnchorByComment(@Nonnull InternalCommitDiscussion discussion, long commentId) {
        return ((CommitDiscussionCommentAnchorDao)this.anchorDao).getAnchorByComment(discussion, commentId);
    }

    @Override
    protected void addActivity(@Nonnull InternalCommitDiscussion discussion, @Nonnull InternalComment comment, InternalCommitDiscussionCommentAnchor anchor, @Nonnull CommentAction action, @Nonnull InternalApplicationUser user) {
        this.activityDao.create((Object)((InternalCommitDiscussionCommentActivity.Builder)((InternalCommitDiscussionCommentActivity.Builder)new InternalCommitDiscussionCommentActivity.Builder(discussion).comment(comment).commentAction(action).commentAnchor(anchor).createdDate(comment.getUpdatedDate())).user(user)).build());
    }

    @Override
    protected void deleteActivities(@Nonnull InternalCommitDiscussion discussion, @Nonnull InternalComment comment) {
        this.activityDao.deleteByComment(comment.getId());
    }

    @Override
    protected Function<InternalComment, InternalCommitDiscussionCommentAnchor> diffAnchor(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddDiffCommentRequest request) {
        return new CommitDiffCommentAnchorFunction(discussion, (AbstractAddCommentRequest)request);
    }

    @Override
    protected Function<InternalComment, InternalCommitDiscussionCommentAnchor> fileAnchor(@Nonnull InternalCommitDiscussion discussion, @Nonnull AddFileCommentRequest request) {
        return new CommitDiffCommentAnchorFunction(discussion, (AbstractAddCommentRequest)request);
    }

    private <R extends AbstractAddCommentRequest> R validateToHash(InternalCommitDiscussion discussion, R request) {
        if (((AbstractAddCommentRequest)Preconditions.checkNotNull(request, (Object)"request")).getToHash() != null && !discussion.getCommitId().equals(request.getToHash())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.discussion.comment.invalidtohash", new Object[]{request.getToHash(), discussion.getCommitId()}));
        }
        return request;
    }

    private static class CommitDiffCommentAnchorFunction
    implements Function<InternalComment, InternalCommitDiscussionCommentAnchor> {
        private final InternalCommitDiscussion discussion;
        private final AbstractAddCommentRequest request;

        public CommitDiffCommentAnchorFunction(InternalCommitDiscussion discussion, AbstractAddCommentRequest request) {
            this.discussion = discussion;
            this.request = request;
        }

        @Override
        public InternalCommitDiscussionCommentAnchor apply(InternalComment comment) {
            return ((InternalCommitDiscussionCommentAnchor.Builder)((InternalCommitDiscussionCommentAnchor.Builder)((InternalCommitDiscussionCommentAnchor.Builder)((InternalCommitDiscussionCommentAnchor.Builder)new InternalCommitDiscussionCommentAnchor.Builder(this.discussion).apply(this.request)).comment(comment)).fromHash(StringUtils.defaultString((String)this.request.getFromHash(), (String)this.discussion.getParentId()))).toHash(this.discussion.getCommitId())).build();
        }
    }
}

