/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentPropertyContext;
import com.atlassian.bitbucket.comment.CommentPropertyProvider;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.content.AbstractProviderContext;
import com.atlassian.stash.internal.plugin.CommentPropertyProviderDescriptor;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PluginCommentPostProcessor
implements CommentPostProcessor {
    private static final Predicate<InternalComment> HAS_PROPERTIES = InternalComment::hasProperties;
    private final PluginAccessor pluginAccessor;

    public PluginCommentPostProcessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public InternalComment process(InternalCommentable entity, InternalComment comment) {
        if (HAS_PROPERTIES.apply((Object)comment)) {
            return comment;
        }
        Context context = new Context((Commentable)entity, (Comment)comment);
        this.enrich(context);
        return new Enricher(context).apply(comment);
    }

    @Override
    public Set<InternalComment> processAll(InternalCommentable entity, Set<InternalComment> comments) {
        Set toProcess = Sets.filter(comments, (Predicate)Predicates.not(HAS_PROPERTIES));
        Context context = new Context((Commentable)entity, toProcess);
        this.enrich(context);
        return ImmutableSet.copyOf((Iterable)Iterables.transform(comments, (Function)new Enricher(context)));
    }

    private void enrich(Context context) {
        int commentCount = Iterables.size((Iterable)((Object)context));
        this.provideProperties(context, commentCount);
    }

    private Stream<CommentPropertyProvider> getPropertyProviders() {
        return ModuleDescriptorUtils.toModules(this.pluginAccessor.getEnabledModuleDescriptorsByClass(CommentPropertyProviderDescriptor.class).stream());
    }

    private void provideProperties(Context context, int commentCount) {
        this.getPropertyProviders().forEach(propertyProvider -> {
            try (Timer ignored = TimerUtils.start((String)String.format("%s.provideProperties for %d comments", propertyProvider.getClass().getName(), commentCount));){
                propertyProvider.provideProperties((CommentPropertyContext)context);
            }
        });
    }

    private static class Enricher
    implements Function<InternalComment, InternalComment> {
        private final Context context;

        public Enricher(Context context) {
            this.context = context;
        }

        public InternalComment apply(InternalComment comment) {
            this.apply((Iterable<InternalComment>)ImmutableList.of((Object)comment));
            return comment;
        }

        private void apply(Iterable<InternalComment> comments) {
            for (InternalComment comment : comments) {
                if (!comment.hasProperties()) {
                    comment.setProperties(this.context.getPropertiesFor(comment));
                }
                this.apply(comment.getComments());
            }
        }
    }

    private static class Context
    extends AbstractProviderContext<Comment>
    implements CommentPropertyContext {
        private final Commentable entity;

        private Context(Commentable entity, Comment comment) {
            this(entity, (Set<? extends Comment>)ImmutableSet.of((Object)comment));
        }

        private Context(Commentable entity, Set<? extends Comment> comments) {
            super(comments);
            this.entity = entity;
        }

        public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
            Preconditions.checkNotNull(visitor, (Object)"visitor");
            if (this.entity instanceof PullRequest) {
                return (T)visitor.visit((PullRequest)this.entity);
            }
            if (this.entity instanceof CommitDiscussion) {
                return (T)visitor.visit((CommitDiscussion)this.entity);
            }
            throw new UnsupportedOperationException("Cannot visit " + this.entity.getClass());
        }
    }
}

