/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.RemoveSetupConfigurationRequest;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.InternalLicenseService;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.profiles.Production;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Production
@Component(value="bootstrapOperation")
public class BootstrapOperation
implements UncheckedOperation<Void> {
    @VisibleForTesting
    static final String KEY_MIRROR_UPSTREAM = "plugin.mirroring.upstream.url";
    static final String LICENSE_MIRROR = "AAABIg0ODAoPeNp9kE1rwzAMhu/9FYadU5KMtKNgWD9y6Javtd3uaqquhsQJkh2Wf7+QuIfuMDAYp\nPd9JL1PaaPFm9UiiESwWEX+KnoRm+NJhH4QzdgA3+ZxB5UFoxotr1AxuvIOuSTVjvX4p1WEF1GpE\njWjuDYk7PCfe1EroobYmbaEI2kHBmXo+77nB8O7dxttoDQZ1ChTVd4AK3E09lKDdooUlDaoQZc4z\nuzvoOABNEBUh9KQxUd0PAAqWfMEfQVTAbMCPS+b2imT6YZT3+K4yDZP0/iw3a+T2RGpQ9rv5OY9z\nL3nZfbhhUlx8L4Wy7VzF0BGI41OV8rpG7TiKcH1faIoTC8Sc3GizNZnpPz6yUgsg8dd/ju1sDQEx\nfg30V9DOaGBMC0CFHdPkXYEvhWZq+KUramWa12MMSkVAhUAgFLcsMhCFa1Ziuzj/fdVQzr5SNI=X\n02em";
    private static final Logger log = LoggerFactory.getLogger(BootstrapOperation.class);
    protected final DirectoryManager directoryManager;
    protected final InternalApplicationPropertiesService propertiesService;
    protected final LicenseHelper licenseHelper;
    protected final Properties applicationProperties;
    protected final InternalLicenseService licenseService;
    protected final ApplicationMode applicationMode;
    private final ApplicationManager appManager;
    private final ConfigurationService configurationService;
    private final GlobalPermissionDao globalPermissionDao;
    private final ApplicationPropertyDao applicationPropertyDao;
    private final StashUserDao userDao;

    @Autowired
    public BootstrapOperation(DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, StashUserDao userDao, Properties applicationProperties, ApplicationManager appManager, LicenseHelper licenseHelper, ConfigurationService configurationService, GlobalPermissionDao globalPermissionDao, ApplicationPropertyDao applicationPropertyDao, InternalLicenseService licenseService) {
        this.directoryManager = directoryManager;
        this.propertiesService = propertiesService;
        this.userDao = userDao;
        this.applicationProperties = applicationProperties;
        this.appManager = appManager;
        this.licenseHelper = licenseHelper;
        this.configurationService = configurationService;
        this.globalPermissionDao = globalPermissionDao;
        this.applicationPropertyDao = applicationPropertyDao;
        this.licenseService = licenseService;
        this.applicationMode = propertiesService.getMode();
    }

    @Transactional
    public Void perform() {
        Application application = this.createApplication();
        Directory directory = this.createDirectory(application);
        this.addDefaultGroup(directory);
        RemoveSetupConfigurationRequest.Builder setupConfigurationBuilder = new RemoveSetupConfigurationRequest.Builder();
        boolean isSetup = this.setupLicense(setupConfigurationBuilder);
        if (isSetup) {
            isSetup = this.setupUsers(setupConfigurationBuilder, directory);
        }
        isSetup &= this.setupBaseUrl(setupConfigurationBuilder);
        isSetup &= this.setupDisplayName(setupConfigurationBuilder);
        if (this.applicationMode == ApplicationMode.MIRROR) {
            isSetup &= StringUtils.isNotBlank((CharSequence)this.applicationProperties.getProperty(KEY_MIRROR_UPSTREAM));
        }
        if (isSetup) {
            this.propertiesService.setSetup(true);
            log.info("Application setup completed successfully");
        }
        if (setupConfigurationBuilder.hasPropertiesToRemove()) {
            this.configurationService.removeSetupProperties(setupConfigurationBuilder.build());
        }
        return null;
    }

    protected boolean setupLicense(RemoveSetupConfigurationRequest.Builder builder) {
        ApplicationProperty currentLicenseProperty = this.applicationPropertyDao.getById(ApplicationProperty.Key.LICENSE);
        String currentLicense = currentLicenseProperty == null ? null : currentLicenseProperty.getValue();
        String setupLicense = this.applicationProperties.getProperty("setup.license");
        if (StringUtils.isNotBlank((CharSequence)currentLicense)) {
            if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
                log.warn("Found {} property in {}, but ignored it because it's already set up", (Object)"setup.license", (Object)"bitbucket.properties");
            }
            return true;
        }
        if (this.applicationMode == ApplicationMode.MIRROR) {
            if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
                log.warn("Found {} property in {}, but ignored it because this is a mirror", (Object)"setup.license", (Object)"bitbucket.properties");
            }
            this.licenseService.setUnvalidated(LICENSE_MIRROR);
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
            DualLicense dualLicense;
            log.info("Found {} property in {}", (Object)"setup.license", (Object)"bitbucket.properties");
            try {
                dualLicense = this.licenseHelper.decode(setupLicense);
            }
            catch (IllegalArgumentException iae) {
                dualLicense = null;
            }
            if (dualLicense == null) {
                log.error("Property {} in {} is not valid", (Object)"setup.license", (Object)"bitbucket.properties");
                return false;
            }
            this.licenseHelper.set(setupLicense);
            builder.removeLicense();
            return true;
        }
        return false;
    }

    protected boolean setupBaseUrl(RemoveSetupConfigurationRequest.Builder builder) {
        URI baseUrl = this.propertiesService.getBaseUrl();
        String baseUrlString = this.applicationProperties.getProperty("setup.baseUrl");
        if (baseUrl != null) {
            if (StringUtils.isNotBlank((CharSequence)baseUrlString)) {
                log.warn("Found {} property in {}, but ignored it because it's already set up", (Object)"setup.baseUrl", (Object)"bitbucket.properties");
            }
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)baseUrlString)) {
            log.info("Found {} property in {}", (Object)"setup.baseUrl", (Object)"bitbucket.properties");
            try {
                this.propertiesService.setBaseURL(new URI(baseUrlString));
            }
            catch (URISyntaxException e) {
                log.error("Property {} in {} is not valid: {}", new Object[]{"setup.baseUrl", "bitbucket.properties", e.getMessage()});
                return false;
            }
            builder.removeBaseUrl();
            return true;
        }
        return false;
    }

    protected boolean setupUsers(RemoveSetupConfigurationRequest.Builder builder, Directory directory) {
        try {
            boolean someAdminPropsSupplied;
            Set<String> missingAdminProps = this.findMissingAdminProps(this.applicationProperties);
            boolean someAdminPropsMissing = missingAdminProps.size() > 0;
            boolean bl = someAdminPropsSupplied = missingAdminProps.size() < ApplicationConstants.SETUP_USER_PROPERTIES.size();
            if (this.applicationMode == ApplicationMode.MIRROR) {
                if (someAdminPropsSupplied) {
                    log.warn("Found sysadmin user properties in {}, but ignored them because this is a mirror and cannot manage local users", (Object)"bitbucket.properties");
                }
                return true;
            }
            if (this.usersExist()) {
                if (someAdminPropsSupplied) {
                    log.warn("Found sysadmin user properties in {}, but ignored them because user(s) already exist", (Object)"bitbucket.properties");
                }
                return true;
            }
            if (someAdminPropsMissing) {
                if (someAdminPropsSupplied) {
                    log.error("Aborting the creation of the initial sysadmin user: not all the needed properties are available in {}. Missing keys: {}", (Object)"bitbucket.properties", (Object)missingAdminProps.toString());
                }
                return false;
            }
            log.info("Creating initial sysadmin user...");
            this.createUser(directory, this.applicationProperties.getProperty("setup.sysadmin.username"), this.applicationProperties.getProperty("setup.sysadmin.password"), this.applicationProperties.getProperty("setup.sysadmin.displayName"), this.applicationProperties.getProperty("setup.sysadmin.emailAddress"), true, true);
            log.info("Created the initial sysadmin, user name: {}", (Object)this.applicationProperties.getProperty("setup.sysadmin.username"));
            builder.removeSysAdmin();
            return true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void createUser(Directory directory, String username, String password, String displayName, String emailAddress, boolean addToDefaultGroup, boolean isSysAdmin) throws Exception {
        UserTemplate userTemplate = new UserTemplate(username, username, username, displayName);
        userTemplate.setDirectoryId(directory.getId().longValue());
        userTemplate.setEmailAddress(emailAddress);
        userTemplate.setActive(true);
        this.directoryManager.addUser(directory.getId().longValue(), userTemplate, new PasswordCredential(password));
        if (addToDefaultGroup) {
            this.directoryManager.addUserToGroup(directory.getId().longValue(), username, "stash-users");
        }
        if (isSysAdmin) {
            InternalNormalUser user = this.userDao.findByName(username);
            this.globalPermissionDao.create((Object)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(Permission.SYS_ADMIN)).user((InternalApplicationUser)user)).build());
        }
    }

    protected boolean usersExist() {
        return this.userDao.findAll(PageUtils.newRequest((int)0, (int)1)).getSize() > 0;
    }

    private Group addDefaultGroup(Directory directory) {
        Group group;
        Long directoryId = directory.getId();
        try {
            group = this.directoryManager.findGroupByName(directoryId.longValue(), "stash-users");
        }
        catch (GroupNotFoundException gnfe) {
            try {
                log.debug("Add group");
                group = this.directoryManager.addGroup(directoryId.longValue(), new GroupTemplate("stash-users", directoryId.longValue()));
                this.globalPermissionDao.create((Object)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().group("stash-users")).permission(Permission.LICENSED_USER)).build());
                log.info("Group added");
            }
            catch (CrowdException | PermissionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return group;
    }

    private Directory createDirectory(Application application) {
        Directory directory;
        try {
            directory = this.directoryManager.findDirectoryByName(ApplicationConstants.INTERNAL_DIRECTORY_NAME);
        }
        catch (DirectoryNotFoundException e) {
            log.debug("Create directory");
            DirectoryImpl newDirectory = this.createDirectory(ApplicationConstants.INTERNAL_DIRECTORY_NAME, true, ApplicationConstants.INTERNAL_DIRECTORY_NAME, DirectoryType.INTERNAL, InternalDirectory.class, OperationType.values(), (Map<String, String>)ImmutableMap.of((Object)"user_encryption_method", (Object)"atlassian-security"));
            log.info("Directory created");
            try {
                directory = this.directoryManager.addDirectory((Directory)newDirectory);
            }
            catch (DirectoryInstantiationException die) {
                throw Throwables.propagate((Throwable)die);
            }
        }
        try {
            this.appManager.addDirectoryMapping(application, directory, true, OperationType.values());
        }
        catch (CrowdException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return directory;
    }

    private Application createApplication() {
        try {
            return this.appManager.findByName("crowd-embedded");
        }
        catch (ApplicationNotFoundException e) {
            log.debug("Create application");
            ApplicationImpl newApplication = this.createApplication("crowd-embedded", ApplicationType.CROWD, PasswordCredential.NONE);
            newApplication.setMembershipAggregationEnabled(true);
            log.info("Application created");
            try {
                return this.appManager.add((Application)newApplication);
            }
            catch (InvalidCredentialException ice) {
                throw Throwables.propagate((Throwable)ice);
            }
        }
    }

    private boolean setupDisplayName(RemoveSetupConfigurationRequest.Builder setupConfigurationBuilder) {
        String displayName = this.propertiesService.getDisplayName();
        String displayNameConfig = this.applicationProperties.getProperty("setup.displayName");
        if (StringUtils.isBlank((CharSequence)displayName)) {
            if (StringUtils.isBlank((CharSequence)displayNameConfig)) {
                if (this.applicationMode == ApplicationMode.MIRROR) {
                    return false;
                }
                this.propertiesService.setDisplayName(ApplicationConstants.PRODUCT_NAME);
            } else {
                log.info("Found {} property in {}", (Object)"setup.displayName", (Object)"bitbucket.properties");
                this.propertiesService.setDisplayName(displayNameConfig);
                setupConfigurationBuilder.removeDisplayName();
            }
        } else if (StringUtils.isNotBlank((CharSequence)displayNameConfig)) {
            log.warn("Found {} property in {}, but ignored it because it's already set up", (Object)"setup.displayName", (Object)"bitbucket.properties");
        }
        return true;
    }

    private Set<String> findMissingAdminProps(Properties properties) {
        HashSet missingProperties = Sets.newHashSet();
        for (String propertyName : ApplicationConstants.SETUP_USER_PROPERTIES) {
            this.checkAndAdd(properties, propertyName, missingProperties);
        }
        return missingProperties;
    }

    private void checkAndAdd(Properties properties, String property, Set<String> missingProperties) {
        if (StringUtils.isBlank((CharSequence)properties.getProperty(property))) {
            missingProperties.add(property);
        }
    }

    private DirectoryImpl createDirectory(String name, boolean isActive, String description, DirectoryType type, Class implementationClass, OperationType[] operations, Map<String, String> attributes) {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setName(name);
        directory.setActive(isActive);
        directory.setDescription(description);
        directory.setType(type);
        directory.setImplementationClass(implementationClass.getName());
        for (OperationType operationType : operations) {
            directory.addAllowedOperation(operationType);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            directory.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return directory;
    }

    private ApplicationImpl createApplication(String name, ApplicationType type, PasswordCredential credential) {
        return ApplicationImpl.newInstanceWithCredential((String)name, (ApplicationType)type, (PasswordCredential)credential);
    }
}

