/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class EmbeddedCrowdHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private final I18nService i18nService;
    private final UserService userService;

    public EmbeddedCrowdHttpAuthenticationHandler(I18nService i18nService, UserService userService) {
        this.i18nService = i18nService;
        this.userService = userService;
    }

    public ApplicationUser authenticate(@Nonnull HttpAuthenticationContext context) {
        String password;
        String username = context.getUsername();
        String string = password = context.getCredentials() instanceof String ? (String)context.getCredentials() : null;
        if (username == null || password == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
            throw this.newBadCredentials();
        }
        try {
            return this.userService.authenticate(username, password);
        }
        catch (IncorrectPasswordAuthenticationException | NoSuchUserException e) {
            throw this.newBadCredentials();
        }
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }

    private IncorrectPasswordAuthenticationException newBadCredentials() {
        throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.auth.failed", new Object[0]));
    }
}

