/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import javax.annotation.Nonnull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class DefaultAuthenticationContext
implements InternalAuthenticationContext,
StatefulService {
    public boolean isAuthenticated() {
        return this.getCurrentUser() != null;
    }

    public ApplicationUser getCurrentUser() {
        StashUserAuthenticationToken token = this.getCurrentToken();
        return token != null ? token.getPrincipal() : null;
    }

    public StashUserAuthenticationToken getCurrentToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)authentication;
        }
        return null;
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return new TransferableState(){

            public void apply() {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }

            public void remove() {
                SecurityContextHolder.clearContext();
            }
        };
    }
}

