/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.scm.pull.MinimalPullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleMinimalPullRequest
implements MinimalPullRequest {
    private final ApplicationUser author;
    private final long id;
    private final PullRequestRef fromRef;
    private final long globalId;
    private final Date rescopeDate;
    private final PullRequestRef toRef;
    private final int version;

    public SimpleMinimalPullRequest(InternalPullRequest pullRequest) {
        this.author = pullRequest.getCreatedBy();
        this.id = pullRequest.getId();
        this.fromRef = pullRequest.getFromRef();
        this.globalId = pullRequest.getGlobalId();
        this.rescopeDate = pullRequest.getRescopedDate();
        this.toRef = pullRequest.getToRef();
        this.version = pullRequest.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMinimalPullRequest that = (SimpleMinimalPullRequest)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.globalId, that.globalId) && Objects.equals(this.version, that.version);
    }

    @Nonnull
    public ApplicationUser getCreatedBy() {
        return this.author;
    }

    @Nonnull
    public PullRequestRef getFromRef() {
        return this.fromRef;
    }

    public long getGlobalId() {
        return this.globalId;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Date getRescopeDate() {
        return this.rescopeDate;
    }

    @Nonnull
    public PullRequestRef getToRef() {
        return this.toRef;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.globalId, this.version);
    }
}

