/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.content.DiffContentCallbackAdapter;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DiffContentCallbackFilter
extends DiffContentCallbackAdapter {
    private final DiffContentFilter filter;
    private Operation<Void, IOException> diffOp;
    private int dstLine = 0;
    private int srcLine = 0;
    private DiffSegmentType segmentType;

    public DiffContentCallbackFilter(DiffContentCallback callback, DiffContentFilter filter) {
        super(callback);
        this.filter = filter;
    }

    public static DiffContentCallback filter(@Nonnull DiffContentCallback callback, @Nullable DiffContentFilter filter) {
        return filter == null ? callback : new DiffContentCallbackFilter(callback, filter);
    }

    @Override
    public void onBinary(@Nullable Path src, @Nullable Path dst) throws IOException {
    }

    @Override
    public void onDiffStart(final @Nullable Path src, final @Nullable Path dst) throws IOException {
        this.diffOp = new Operation<Void, IOException>(){

            public Void perform() throws IOException {
                DiffContentCallbackFilter.super.onDiffStart(src, dst);
                return null;
            }
        };
    }

    @Override
    public void onDiffEnd(boolean truncated) throws IOException {
        if (this.diffOp == null) {
            super.onDiffEnd(truncated);
        }
    }

    @Override
    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan) throws IOException {
        this.srcLine = srcLine;
        this.dstLine = dstLine;
    }

    @Override
    public void onHunkEnd(boolean truncated) throws IOException {
    }

    @Override
    public void onSegmentStart(@Nonnull DiffSegmentType type) throws IOException {
        this.segmentType = type;
    }

    @Override
    public void onSegmentEnd(boolean truncated) throws IOException {
    }

    @Override
    public void onSegmentLine(@Nonnull String line, @Nullable ConflictMarker marker, boolean truncated) throws IOException {
        if (this.filter.apply(line)) {
            if (this.diffOp != null) {
                this.diffOp.perform();
                this.diffOp = null;
            }
            super.onHunkStart(this.srcLine, this.segmentType == DiffSegmentType.ADDED ? 0 : 1, this.dstLine, this.segmentType == DiffSegmentType.REMOVED ? 0 : 1);
            super.onSegmentStart(this.segmentType);
            super.onSegmentLine(line, marker, truncated);
            super.onSegmentEnd(false);
            super.onHunkEnd(false);
        }
        if (this.segmentType != DiffSegmentType.ADDED) {
            ++this.srcLine;
        }
        if (this.segmentType != DiffSegmentType.REMOVED) {
            ++this.dstLine;
        }
    }
}

