/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.experimental.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryCloneEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.base.Preconditions;
import java.time.Duration;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.repository.cloned")
public class AnalyticsRepositoryCloneEvent
extends RepositoryCloneEvent {
    private final long bytesRead;
    private final long bytesWritten;
    private final long duration;

    public AnalyticsRepositoryCloneEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull RequestContext requestContext) {
        super(source, repository);
        Preconditions.checkNotNull((Object)requestContext, (Object)"requestContext");
        this.bytesRead = requestContext.getBytesRead();
        this.bytesWritten = requestContext.getBytesWritten();
        this.duration = requestContext.getDuration().map(Duration::toMillis).orElse(0L);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getDuration() {
        return this.duration;
    }
}

