/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class RemoveSetupConfigurationRequest {
    private boolean removeLicense;
    private boolean removeSysAdmin;
    private boolean removeBaseUrl;
    private boolean removeDisplayName;

    private RemoveSetupConfigurationRequest(boolean removeLicense, boolean removeSysAdmin, boolean removeBaseUrl, boolean removeDisplayName) {
        this.removeLicense = removeLicense;
        this.removeSysAdmin = removeSysAdmin;
        this.removeBaseUrl = removeBaseUrl;
        this.removeDisplayName = removeDisplayName;
    }

    public boolean isRemoveLicense() {
        return this.removeLicense;
    }

    public boolean isRemoveSysAdmin() {
        return this.removeSysAdmin;
    }

    public boolean isRemoveBaseUrl() {
        return this.removeBaseUrl;
    }

    public boolean isRemoveDisplayName() {
        return this.removeDisplayName;
    }

    public Set<String> toProperties() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.removeLicense) {
            builder.add((Object)"setup.license");
        }
        if (this.removeSysAdmin) {
            builder.add((Object)"setup.sysadmin.username");
            builder.add((Object)"setup.sysadmin.password");
            builder.add((Object)"setup.sysadmin.displayName");
            builder.add((Object)"setup.sysadmin.emailAddress");
        }
        if (this.removeBaseUrl) {
            builder.add((Object)"setup.baseUrl");
        }
        if (this.removeDisplayName) {
            builder.add((Object)"setup.displayName");
        }
        return builder.build();
    }

    public static class Builder {
        private boolean removeLicense;
        private boolean removeSysAdmin;
        private boolean removeBaseUrl;
        private boolean removeDisplayName;

        public boolean hasPropertiesToRemove() {
            return this.removeLicense || this.removeSysAdmin || this.removeBaseUrl || this.removeDisplayName;
        }

        public Builder removeLicense() {
            this.removeLicense = true;
            return this;
        }

        public Builder removeSysAdmin() {
            this.removeSysAdmin = true;
            return this;
        }

        public Builder removeBaseUrl() {
            this.removeBaseUrl = true;
            return this;
        }

        public Builder removeDisplayName() {
            this.removeDisplayName = true;
            return this;
        }

        public RemoveSetupConfigurationRequest build() {
            return new RemoveSetupConfigurationRequest(this.removeLicense, this.removeSysAdmin, this.removeBaseUrl, this.removeDisplayName);
        }
    }
}

