/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.util.IoUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class TypeDetectingCopyOutputHandler
extends BaseCommandHandler
implements CommandOutputHandler<Void> {
    private static final int BUFFER_SIZE = 8192;
    private final int bufferSize;
    private final TypeAwareOutputSupplier outputSupplier;
    private final String path;

    public TypeDetectingCopyOutputHandler(TypeAwareOutputSupplier outputSupplier, String path) {
        this(outputSupplier, path, 8192);
    }

    public TypeDetectingCopyOutputHandler(TypeAwareOutputSupplier outputSupplier, String path, int bufferSize) {
        this.bufferSize = Math.max(bufferSize, 8192);
        this.outputSupplier = outputSupplier;
        this.path = path;
    }

    public Void getOutput() {
        return null;
    }

    public void process(@Nonnull InputStream output) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(output, this.bufferSize);){
            ((InputStream)stream).mark(2);
            int read = ((InputStream)stream).read();
            if (read == -1) {
                return;
            }
            ((InputStream)stream).reset();
            String type = ContentDetectionUtils.detectContentType(stream, this.path);
            if (type == null) {
                type = ContentDetectionUtils.isBinary(stream, 8192) ? "application/octet-stream" : "text/plain";
            }
            try (OutputStream outputStream = this.outputSupplier.getStream(type);){
                IoUtils.copy((InputStream)stream, (OutputStream)outputStream, (int)this.bufferSize);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }
}

